/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.scaffolding;

import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.BlockPlaceCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.utils.anticheat.update.BlockPlace;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.math.VectorUtils;
import org.bukkit.util.Vector;

@CheckData(name="FarPlace")
public class FarPlace
extends BlockPlaceCheck {
    public FarPlace(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onBlockPlace(BlockPlace place) {
        Vector3i blockPos = place.getPlacedAgainstBlockLocation();
        if (place.getMaterial() == StateTypes.SCAFFOLDING) {
            return;
        }
        double min = Double.MAX_VALUE;
        for (double d : this.player.getPossibleEyeHeights()) {
            SimpleCollisionBox box = new SimpleCollisionBox(blockPos);
            Vector eyes = new Vector(this.player.x, this.player.y + d, this.player.z);
            Vector best = VectorUtils.cutBoxToVector(eyes, box);
            min = Math.min(min, eyes.distanceSquared(best));
        }
        double maxReach = this.player.gamemode == GameMode.CREATIVE ? 6.0 : 4.5;
        double threshold = this.player.getMovementThreshold();
        if (min > (maxReach += Math.hypot(threshold, threshold)) * maxReach && this.flagAndAlert() && this.shouldModifyPackets()) {
            place.resync();
        }
    }
}

