/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.prediction;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.events.CompletePredictionEvent;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

@CheckData(name="Simulation", configName="Simulation", decay=0.02)
public class OffsetHandler
extends Check
implements PostPredictionCheck {
    double setbackDecayMultiplier;
    double threshold;
    double immediateSetbackThreshold;
    double maxAdvantage;
    double maxCeiling;
    double advantageGained = 0.0;
    private static final AtomicInteger flags = new AtomicInteger(0);

    public OffsetHandler(GrimPlayer player) {
        super(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPredictionComplete(PredictionComplete predictionComplete) {
        double offset = predictionComplete.getOffset();
        if (!predictionComplete.isChecked()) {
            return;
        }
        CompletePredictionEvent completePredictionEvent = new CompletePredictionEvent(this.getPlayer(), this, predictionComplete.getOffset());
        Bukkit.getPluginManager().callEvent((Event)completePredictionEvent);
        if (completePredictionEvent.isCancelled()) {
            return;
        }
        if ((offset >= this.threshold || offset >= this.immediateSetbackThreshold) && this.flag()) {
            this.advantageGained += offset;
            boolean isSetback = this.advantageGained >= this.maxAdvantage || offset >= this.immediateSetbackThreshold;
            this.giveOffsetLenienceNextTick(offset);
            if (isSetback) {
                this.player.getSetbackTeleportUtil().executeViolationSetback();
            }
            this.violations += 1.0;
            AtomicInteger atomicInteger = flags;
            synchronized (atomicInteger) {
                String humanFormattedOffset;
                int flagId = (flags.get() & 0xFF) + 1;
                if (offset < 0.001) {
                    humanFormattedOffset = String.format("%.4E", offset);
                    humanFormattedOffset = humanFormattedOffset.replace("E-0", "E-");
                } else {
                    humanFormattedOffset = String.format("%6f", offset);
                    humanFormattedOffset = humanFormattedOffset.replace("0.", ".");
                }
                if (this.alert(humanFormattedOffset + " /gl " + flagId)) {
                    flags.incrementAndGet();
                    predictionComplete.setIdentifier(flagId);
                }
            }
            this.advantageGained = Math.min(this.advantageGained, this.maxCeiling);
        } else {
            this.advantageGained *= this.setbackDecayMultiplier;
        }
        this.removeOffsetLenience();
    }

    private void giveOffsetLenienceNextTick(double offset) {
        double minimizedOffset;
        this.player.uncertaintyHandler.lastHorizontalOffset = minimizedOffset = Math.min(offset, 1.0);
        this.player.uncertaintyHandler.lastVerticalOffset = minimizedOffset;
    }

    private void removeOffsetLenience() {
        this.player.uncertaintyHandler.lastHorizontalOffset = 0.0;
        this.player.uncertaintyHandler.lastVerticalOffset = 0.0;
    }

    @Override
    public void reload() {
        super.reload();
        this.setbackDecayMultiplier = this.getConfig().getDoubleElse("Simulation.setback-decay-multiplier", 0.999);
        this.threshold = this.getConfig().getDoubleElse("Simulation.threshold", 0.001);
        this.immediateSetbackThreshold = this.getConfig().getDoubleElse("Simulation.immediate-setback-threshold", 0.1);
        this.maxAdvantage = this.getConfig().getDoubleElse("Simulation.max-advantage", 1.0);
        this.maxCeiling = this.getConfig().getDoubleElse("Simulation.max-ceiling", 4.0);
        if (this.maxAdvantage == -1.0) {
            this.maxAdvantage = Double.MAX_VALUE;
        }
        if (this.immediateSetbackThreshold == -1.0) {
            this.immediateSetbackThreshold = Double.MAX_VALUE;
        }
    }

    public boolean doesOffsetFlag(double offset) {
        return offset >= this.threshold;
    }
}

