/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.movement;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerFlying;

@CheckData(name="Timer", configName="TimerA", setback=10.0)
public class TimerCheck
extends Check
implements PacketCheck {
    long timerBalanceRealTime = 0L;
    long knownPlayerClockTime = (long)((double)System.nanoTime() - 6.0E10);
    long lastMovementPlayerClock = (long)((double)System.nanoTime() - 6.0E10);
    long clockDrift = 120000000L;
    boolean hasGottenMovementAfterTransaction = false;

    public TimerCheck(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (this.hasGottenMovementAfterTransaction && this.checkForTransaction(event.getPacketType())) {
            this.knownPlayerClockTime = this.lastMovementPlayerClock;
            this.lastMovementPlayerClock = this.player.getPlayerClockAtLeast();
            this.hasGottenMovementAfterTransaction = false;
        }
        if (!this.shouldCountPacketForTimer(event.getPacketType())) {
            return;
        }
        this.hasGottenMovementAfterTransaction = true;
        this.timerBalanceRealTime = (long)((double)this.timerBalanceRealTime + 5.0E7);
        this.doCheck(event);
    }

    public void doCheck(PacketReceiveEvent event) {
        if (this.timerBalanceRealTime > System.nanoTime()) {
            if (this.flag()) {
                if (this.shouldModifyPackets()) {
                    event.setCancelled(true);
                    this.player.onPacketCancel();
                }
                this.player.getSetbackTeleportUtil().executeNonSimulatingSetback();
                this.alert("");
            }
            this.timerBalanceRealTime = (long)((double)this.timerBalanceRealTime - 5.0E7);
        }
        this.timerBalanceRealTime = Math.max(this.timerBalanceRealTime, this.lastMovementPlayerClock - this.clockDrift);
    }

    public boolean checkForTransaction(PacketTypeCommon packetType) {
        return packetType == PacketType.Play.Client.PONG || packetType == PacketType.Play.Client.WINDOW_CONFIRMATION;
    }

    public boolean shouldCountPacketForTimer(PacketTypeCommon packetType) {
        return WrapperPlayClientPlayerFlying.isFlying(packetType) && !this.player.packetStateData.lastPacketWasTeleport && !this.player.packetStateData.lastPacketWasOnePointSeventeenDuplicate;
    }

    @Override
    public void reload() {
        super.reload();
        this.clockDrift = (long)(this.getConfig().getDoubleElse(this.getConfigName() + ".drift", 120.0) * 1000000.0);
    }
}

