/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.movement;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;

@CheckData(name="NoSlow (Prediction)", configName="NoSlow", setback=5.0)
public class NoSlow
extends Check
implements PostPredictionCheck {
    double offsetToFlag;
    double bestOffset = 1.0;
    public boolean didSlotChangeLastTick = false;
    public boolean flaggedLastTick = false;

    public NoSlow(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPredictionComplete(PredictionComplete predictionComplete) {
        if (!predictionComplete.isChecked()) {
            return;
        }
        if (this.player.packetStateData.slowedByUsingItem) {
            if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8) && this.didSlotChangeLastTick) {
                this.didSlotChangeLastTick = false;
                this.flaggedLastTick = false;
            }
            if (this.bestOffset > this.offsetToFlag) {
                if (this.flaggedLastTick) {
                    this.flagWithSetback();
                    this.alert("");
                }
                this.flaggedLastTick = true;
            } else {
                this.reward();
                this.flaggedLastTick = false;
            }
        }
        this.bestOffset = 1.0;
    }

    public void handlePredictionAnalysis(double offset) {
        this.bestOffset = Math.min(this.bestOffset, offset);
    }

    @Override
    public void reload() {
        super.reload();
        this.offsetToFlag = this.getConfig().getDoubleElse("NoSlow.threshold", 1.0E-5);
    }
}

