/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.movement;

import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.impl.movement.TimerCheck;
import ac.grim.grimac.checks.type.PostPredictionCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.utils.anticheat.update.PredictionComplete;

@CheckData(name="NegativeTimer", configName="NegativeTimer", setback=10.0)
public class NegativeTimerCheck
extends TimerCheck
implements PostPredictionCheck {
    public NegativeTimerCheck(GrimPlayer player) {
        super(player);
        this.timerBalanceRealTime = System.nanoTime() + this.clockDrift;
    }

    @Override
    public void onPredictionComplete(PredictionComplete predictionComplete) {
        if (!this.player.canThePlayerBeCloseToZeroMovement(2) || !predictionComplete.isChecked()) {
            this.timerBalanceRealTime = System.nanoTime() + this.clockDrift;
        }
        if (this.timerBalanceRealTime < this.lastMovementPlayerClock - this.clockDrift) {
            int lostMS = (int)((double)(System.nanoTime() - this.timerBalanceRealTime) / 1000000.0);
            this.flagAndAlert("-" + lostMS);
            this.timerBalanceRealTime = (long)((double)this.timerBalanceRealTime + 5.0E7);
        }
    }

    @Override
    public void doCheck(PacketReceiveEvent event) {
    }

    @Override
    public void reload() {
        super.reload();
        this.clockDrift = (long)(this.getConfig().getDoubleElse(this.getConfigName() + ".drift", 1200.0) * 1000000.0);
    }
}

