/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.misc;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.PacketEvents;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.manager.server.ServerVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.DiggingAction;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3i;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerFlying;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerAcknowledgeBlockChanges;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBlockChange;
import ac.grim.grimac.utils.math.GrimMath;
import ac.grim.grimac.utils.nmsutil.BlockBreakSpeed;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@CheckData(name="FastBreak")
public class FastBreak
extends Check
implements PacketCheck {
    Vector3i targetBlock = null;
    double maximumBlockDamage = 0.0;
    long lastFinishBreak = 0L;
    long startBreak = 0L;
    double blockBreakBalance = 0.0;
    double blockDelayBalance = 0.0;

    public FastBreak(GrimPlayer playerData) {
        super(playerData);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if ((this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9) ? event.getPacketType() == PacketType.Play.Client.ANIMATION : WrapperPlayClientPlayerFlying.isFlying(event.getPacketType())) && this.targetBlock != null) {
            this.maximumBlockDamage = Math.max(this.maximumBlockDamage, BlockBreakSpeed.getBlockDamage(this.player, this.targetBlock));
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            WrapperPlayClientPlayerDigging digging = new WrapperPlayClientPlayerDigging(event);
            if (digging.getAction() == DiggingAction.START_DIGGING) {
                this.startBreak = System.currentTimeMillis() - (long)(this.targetBlock == null ? 50 : 0);
                this.targetBlock = digging.getBlockPosition();
                this.maximumBlockDamage = BlockBreakSpeed.getBlockDamage(this.player, this.targetBlock);
                double breakDelay = System.currentTimeMillis() - this.lastFinishBreak;
                this.blockDelayBalance = breakDelay >= 275.0 ? (this.blockDelayBalance *= 0.9) : (this.blockDelayBalance += 300.0 - breakDelay);
                if (this.blockDelayBalance > 1000.0 && this.shouldModifyPackets()) {
                    event.setCancelled(true);
                    this.player.onPacketCancel();
                    this.flagAndAlert("Delay=" + breakDelay);
                }
                this.clampBalance();
            }
            if (digging.getAction() == DiggingAction.FINISHED_DIGGING && this.targetBlock != null) {
                double predictedTime = Math.ceil(1.0 / this.maximumBlockDamage) * 50.0;
                double realTime = System.currentTimeMillis() - this.startBreak;
                double diff = predictedTime - realTime;
                this.clampBalance();
                this.blockBreakBalance = diff < 25.0 ? (this.blockBreakBalance *= 0.9) : (this.blockBreakBalance += diff);
                if (this.blockBreakBalance > 1000.0) {
                    Bukkit.getScheduler().runTask((Plugin)GrimAPI.INSTANCE.getPlugin(), () -> {
                        Player bukkitPlayer = this.player.bukkitPlayer;
                        if (bukkitPlayer == null || !bukkitPlayer.isOnline()) {
                            return;
                        }
                        Location location = new Location(bukkitPlayer.getWorld(), (double)digging.getBlockPosition().getX(), (double)digging.getBlockPosition().getY(), (double)digging.getBlockPosition().getZ());
                        if (bukkitPlayer.getLocation().distance(location) < 64.0) {
                            Chunk chunk = bukkitPlayer.getWorld().getChunkAt(digging.getBlockPosition().getX() >> 4, digging.getBlockPosition().getZ() >> 4);
                            if (!chunk.isLoaded()) {
                                return;
                            }
                            Block block = chunk.getBlock(digging.getBlockPosition().getX() & 0xF, digging.getBlockPosition().getY(), digging.getBlockPosition().getZ() & 0xF);
                            int blockId = PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_13) ? WrappedBlockState.getByString(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion(), block.getBlockData().getAsString(false)).getGlobalId() : block.getType().getId() << 4 | block.getData();
                            this.player.user.sendPacket(new WrapperPlayServerBlockChange(digging.getBlockPosition(), blockId));
                            if (PacketEvents.getAPI().getServerManager().getVersion().isNewerThanOrEquals(ServerVersion.V_1_19)) {
                                this.player.user.sendPacket(new WrapperPlayServerAcknowledgeBlockChanges(digging.getSequence()));
                            }
                        }
                    });
                    if (this.flagAndAlert("Diff=" + diff + ",Balance=" + this.blockBreakBalance) && this.shouldModifyPackets()) {
                        event.setCancelled(true);
                        this.player.onPacketCancel();
                    }
                }
                this.lastFinishBreak = System.currentTimeMillis();
            }
            if (digging.getAction() == DiggingAction.CANCELLED_DIGGING) {
                this.targetBlock = null;
            }
        }
    }

    private void clampBalance() {
        double balance = Math.max(1000.0, (double)this.player.getTransactionPing() / 1000000.0);
        this.blockBreakBalance = GrimMath.clamp(this.blockBreakBalance, -balance, balance);
        this.blockDelayBalance = GrimMath.clamp(this.blockDelayBalance, -balance, balance);
    }
}

