/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.misc;

import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.impl.exploit.ExploitA;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPluginMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ClientBrand
extends Check
implements PacketCheck {
    String brand = "vanilla";
    boolean hasBrand = false;

    public ClientBrand(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        WrapperPlayClientPluginMessage packet;
        String channelName;
        if (event.getPacketType() == PacketType.Play.Client.PLUGIN_MESSAGE && ((channelName = (packet = new WrapperPlayClientPluginMessage(event)).getChannelName()).equalsIgnoreCase("minecraft:brand") || packet.getChannelName().equals("MC|Brand"))) {
            byte[] data = packet.getData();
            if (data.length > 64 || data.length == 0) {
                this.brand = "sent " + data.length + " bytes as brand";
            } else if (!this.hasBrand) {
                byte[] minusLength = new byte[data.length - 1];
                System.arraycopy(data, 1, minusLength, 0, minusLength.length);
                this.brand = new String(minusLength).replace(" (Velocity)", "");
                if (this.player.checkManager.getPrePredictionCheck(ExploitA.class).checkString(this.brand)) {
                    this.brand = "sent log4j";
                }
                if (!GrimAPI.INSTANCE.getConfigManager().isIgnoredClient(this.brand)) {
                    String message = GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("client-brand-format", "%prefix% &f%player% joined using %brand%");
                    message = GrimAPI.INSTANCE.getExternalAPI().replaceVariables(this.getPlayer(), message, true);
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        if (!player.hasPermission("grim.brand")) continue;
                        player.sendMessage(message);
                    }
                }
            }
            this.hasBrand = true;
        }
    }

    public String getBrand() {
        return this.brand;
    }
}

