/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.exploit;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientChatMessage;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientNameItem;
import java.util.regex.Pattern;

@CheckData(name="ExploitA", experimental=true)
public class ExploitA
extends Check
implements PacketCheck {
    private static final Pattern EXPLOIT_PATTERN = Pattern.compile("\\$\\{.+}");

    public ExploitA(GrimPlayer playerData) {
        super(playerData);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        WrapperPlayClientNameItem wrapper;
        String name;
        if (event.getPacketType() == PacketType.Play.Client.CHAT_MESSAGE) {
            WrapperPlayClientChatMessage wrapper2 = new WrapperPlayClientChatMessage(event);
            String message = wrapper2.getMessage();
            if (this.checkString(message)) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
        } else if (event.getPacketType() == PacketType.Play.Client.NAME_ITEM && this.checkString(name = (wrapper = new WrapperPlayClientNameItem(event)).getItemName())) {
            event.setCancelled(true);
            this.player.onPacketCancel();
        }
    }

    public boolean checkString(String message) {
        return EXPLOIT_PATTERN.matcher(message).matches() && this.flagAndAlert();
    }
}

