/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.combat;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.entity.type.EntityTypes;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.ClientVersion;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.player.GameMode;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.util.Vector3d;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerFlying;
import ac.grim.grimac.utils.collisions.datatypes.SimpleCollisionBox;
import ac.grim.grimac.utils.data.packetentity.PacketEntity;
import ac.grim.grimac.utils.math.VectorUtils;
import ac.grim.grimac.utils.nmsutil.ReachUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.util.Vector;

@CheckData(name="Reach", configName="Reach", setback=10.0)
public class Reach
extends Check
implements PacketCheck {
    private final Map<Integer, Vector3d> playerAttackQueue = new LinkedHashMap<Integer, Vector3d>();
    private static final List<EntityType> blacklisted = Arrays.asList(EntityTypes.BOAT, EntityTypes.CHEST_BOAT, EntityTypes.SHULKER);
    private boolean cancelImpossibleHits;
    private double threshold;
    private double cancelBuffer;

    public Reach(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (!this.player.disableGrim && event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY) {
            WrapperPlayClientInteractEntity action = new WrapperPlayClientInteractEntity(event);
            if (this.player.getSetbackTeleportUtil().shouldBlockMovement()) {
                event.setCancelled(true);
                this.player.onPacketCancel();
                return;
            }
            PacketEntity entity = this.player.compensatedEntities.entityMap.get(action.getEntityId());
            if (entity == null) {
                if (this.shouldModifyPackets() && this.player.compensatedEntities.serverPositionsMap.containsKey(action.getEntityId())) {
                    event.setCancelled(true);
                    this.player.onPacketCancel();
                }
                return;
            }
            if (entity.type == EntityTypes.ARMOR_STAND && this.player.getClientVersion().isOlderThan(ClientVersion.V_1_8)) {
                return;
            }
            if (this.player.gamemode == GameMode.CREATIVE) {
                return;
            }
            if (this.player.compensatedEntities.getSelf().inVehicle()) {
                return;
            }
            if (entity.riding != null) {
                return;
            }
            this.playerAttackQueue.put(action.getEntityId(), new Vector3d(this.player.x, this.player.y, this.player.z));
            if (this.shouldModifyPackets() && this.cancelImpossibleHits && this.isKnownInvalid(entity)) {
                event.setCancelled(true);
                this.player.onPacketCancel();
            }
        }
        if (WrapperPlayClientPlayerFlying.isFlying(event.getPacketType())) {
            if (this.player.packetStateData.lastPacketWasTeleport || this.player.packetStateData.lastPacketWasOnePointSeventeenDuplicate) {
                return;
            }
            this.tickFlying();
        }
    }

    private boolean isKnownInvalid(PacketEntity reachEntity) {
        boolean giveMovementThresholdLenience;
        boolean bl = giveMovementThresholdLenience = this.player.packetStateData.didLastMovementIncludePosition || this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9);
        if ((blacklisted.contains(reachEntity.type) || !reachEntity.isLivingEntity()) && reachEntity.type != EntityTypes.END_CRYSTAL) {
            return false;
        }
        if (this.player.gamemode == GameMode.CREATIVE) {
            return false;
        }
        if (this.player.compensatedEntities.getSelf().inVehicle()) {
            return false;
        }
        double lowest = 6.0;
        if (this.cancelBuffer != 0.0) {
            return this.checkReach(reachEntity, new Vector3d(this.player.x, this.player.y, this.player.z), true) != null;
        }
        for (double eyes : this.player.getPossibleEyeHeights()) {
            SimpleCollisionBox targetBox = reachEntity.getPossibleCollisionBoxes();
            if (reachEntity.type == EntityTypes.END_CRYSTAL) {
                targetBox = new SimpleCollisionBox(reachEntity.desyncClientPos.subtract(1.0, 0.0, 1.0), reachEntity.desyncClientPos.add(1.0, 2.0, 1.0));
            }
            if (this.player.getClientVersion().isOlderThanOrEquals(ClientVersion.V_1_8)) {
                targetBox.expand(0.1);
            }
            if (giveMovementThresholdLenience) {
                targetBox.expand(this.player.getMovementThreshold());
            }
            Vector from = new Vector(this.player.x, this.player.y + eyes, this.player.z);
            Vector closestPoint = VectorUtils.cutBoxToVector(from, targetBox);
            lowest = Math.min(lowest, closestPoint.distance(from));
        }
        return lowest > 3.0;
    }

    private void tickFlying() {
        for (Map.Entry<Integer, Vector3d> attack : this.playerAttackQueue.entrySet()) {
            String result;
            PacketEntity reachEntity = (PacketEntity)this.player.compensatedEntities.entityMap.get(attack.getKey());
            if (reachEntity == null || (result = this.checkReach(reachEntity, attack.getValue(), false)) == null) continue;
            this.flagAndAlert(result);
        }
        this.playerAttackQueue.clear();
    }

    private String checkReach(PacketEntity reachEntity, Vector3d from, boolean isPrediction) {
        SimpleCollisionBox targetBox = reachEntity.getPossibleCollisionBoxes();
        if (reachEntity.type == EntityTypes.END_CRYSTAL) {
            targetBox = new SimpleCollisionBox(reachEntity.desyncClientPos.subtract(1.0, 0.0, 1.0), reachEntity.desyncClientPos.add(1.0, 2.0, 1.0));
        }
        if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_9)) {
            targetBox.expand(0.1f);
        }
        targetBox.expand(this.threshold);
        if (!this.player.packetStateData.didLastLastMovementIncludePosition || this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
            targetBox.expand(this.player.getMovementThreshold());
        }
        double minDistance = Double.MAX_VALUE;
        List<Vector> possibleLookDirs = new ArrayList<Vector>(Arrays.asList(ReachUtils.getLook(this.player, this.player.xRot, this.player.yRot)));
        if (!isPrediction) {
            possibleLookDirs.add(ReachUtils.getLook(this.player, this.player.lastXRot, this.player.yRot));
            if (this.player.getClientVersion().isNewerThanOrEquals(ClientVersion.V_1_9)) {
                possibleLookDirs.add(ReachUtils.getLook(this.player, this.player.lastXRot, this.player.lastYRot));
            }
            if (this.player.getClientVersion().isOlderThan(ClientVersion.V_1_8)) {
                possibleLookDirs = Collections.singletonList(ReachUtils.getLook(this.player, this.player.xRot, this.player.yRot));
            }
        }
        block0: for (Vector lookVec : possibleLookDirs) {
            for (double eye : this.player.getPossibleEyeHeights()) {
                Vector eyePos = new Vector(from.getX(), from.getY() + eye, from.getZ());
                Vector endReachPos = eyePos.clone().add(new Vector(lookVec.getX() * 6.0, lookVec.getY() * 6.0, lookVec.getZ() * 6.0));
                Vector intercept = ReachUtils.calculateIntercept(targetBox, eyePos, endReachPos).getFirst();
                if (ReachUtils.isVecInside(targetBox, eyePos)) {
                    minDistance = 0.0;
                    continue block0;
                }
                if (intercept == null) continue;
                minDistance = Math.min(eyePos.distance(intercept), minDistance);
            }
        }
        if (!blacklisted.contains(reachEntity.type) && reachEntity.isLivingEntity() || reachEntity.type == EntityTypes.END_CRYSTAL) {
            if (minDistance == Double.MAX_VALUE) {
                this.cancelBuffer = 1.0;
                return "Missed hitbox";
            }
            if (minDistance > 3.0) {
                this.cancelBuffer = 1.0;
                return String.format("%.5f", minDistance) + " blocks";
            }
            this.cancelBuffer = Math.max(0.0, this.cancelBuffer - 0.25);
        }
        return null;
    }

    @Override
    public void reload() {
        super.reload();
        this.cancelImpossibleHits = this.getConfig().getBooleanElse("Reach.block-impossible-hits", true);
        this.threshold = this.getConfig().getDoubleElse("Reach.threshold", 5.0E-4);
    }
}

