/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.badpackets;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientClickWindow;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerOpenWindow;

@CheckData(name="BadPacketsP", experimental=true)
public class BadPacketsP
extends Check
implements PacketCheck {
    private int containerType = -1;
    private int containerId = -1;

    public BadPacketsP(GrimPlayer playerData) {
        super(playerData);
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.OPEN_WINDOW) {
            WrapperPlayServerOpenWindow window = new WrapperPlayServerOpenWindow(event);
            this.containerType = window.getType();
            this.containerId = window.getContainerId();
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.CLICK_WINDOW) {
            WrapperPlayClientClickWindow wrapper = new WrapperPlayClientClickWindow(event);
            int clickType = wrapper.getWindowClickType().ordinal();
            int button = wrapper.getButton();
            boolean flag = false;
            switch (clickType) {
                case 0: 
                case 1: {
                    if (button == 0 || button == 1) break;
                    flag = true;
                    break;
                }
                case 2: {
                    if (button <= 8 && button >= 0 || button == 40) break;
                    flag = true;
                    break;
                }
                case 3: {
                    if (button == 2) break;
                    flag = true;
                    break;
                }
                case 4: 
                case 5: {
                    if (button != 3 && button != 7 && button <= 10 && button >= 0) break;
                    flag = true;
                    break;
                }
                case 6: {
                    if (button == 0) break;
                    flag = true;
                }
            }
            if (flag) {
                this.flagAndAlert("clickType=" + clickType + " button=" + button + (wrapper.getWindowId() == this.containerId ? " container=" + this.containerType : ""));
            }
        }
    }
}

