/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks.impl.badpackets;

import ac.grim.grimac.checks.Check;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.checks.type.PacketCheck;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketReceiveEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.event.PacketSendEvent;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.protocol.packettype.PacketType;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientKeepAlive;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerKeepAlive;
import ac.grim.grimac.utils.data.Pair;
import java.util.LinkedList;
import java.util.Queue;

@CheckData(name="BadPacketsO")
public class BadPacketsO
extends Check
implements PacketCheck {
    Queue<Pair<Long, Long>> keepaliveMap = new LinkedList<Pair<Long, Long>>();

    public BadPacketsO(GrimPlayer player) {
        super(player);
    }

    @Override
    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Play.Server.KEEP_ALIVE) {
            WrapperPlayServerKeepAlive packet = new WrapperPlayServerKeepAlive(event);
            this.keepaliveMap.add(new Pair<Long, Long>(packet.getId(), System.nanoTime()));
        }
    }

    @Override
    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.KEEP_ALIVE) {
            WrapperPlayClientKeepAlive packet = new WrapperPlayClientKeepAlive(event);
            long id = packet.getId();
            boolean hasID = false;
            for (Pair pair : this.keepaliveMap) {
                if ((Long)pair.getFirst() != id) continue;
                hasID = true;
                break;
            }
            if (!hasID) {
                this.flagAndAlert("ID: " + id);
            } else {
                Pair<Long, Long> data;
                while ((data = this.keepaliveMap.poll()) != null && data.getFirst() != id) {
                }
            }
        }
    }
}

