/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac.checks;

import ac.grim.grimac.AbstractCheck;
import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.checks.CheckData;
import ac.grim.grimac.events.FlagEvent;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.configuralize.DynamicConfig;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class Check
implements AbstractCheck {
    protected final GrimPlayer player;
    public double violations;
    private double decay;
    private double setbackVL;
    private String checkName;
    private String configName;
    private String alternativeName;
    private boolean experimental;
    private boolean isEnabled;

    public Check(GrimPlayer player) {
        this.player = player;
        Class<?> checkClass = this.getClass();
        if (checkClass.isAnnotationPresent(CheckData.class)) {
            CheckData checkData = checkClass.getAnnotation(CheckData.class);
            this.checkName = checkData.name();
            this.configName = checkData.configName();
            if (this.configName.equals("DEFAULT")) {
                this.configName = this.checkName;
            }
            this.decay = checkData.decay();
            this.setbackVL = checkData.setback();
            this.alternativeName = checkData.alternativeName();
            this.experimental = checkData.experimental();
        }
        this.reload();
    }

    public boolean shouldModifyPackets() {
        return this.isEnabled && !this.player.disableGrim && !this.player.noModifyPacketPermission;
    }

    public final boolean flagAndAlert(String verbose) {
        if (this.flag()) {
            this.alert(verbose);
            return true;
        }
        return false;
    }

    public final boolean flagAndAlert() {
        return this.flagAndAlert("");
    }

    public final boolean flag() {
        if (this.player.disableGrim || this.experimental && !GrimAPI.INSTANCE.getConfigManager().isExperimentalChecks()) {
            return false;
        }
        FlagEvent event = new FlagEvent(this.player, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.player.punishmentManager.handleViolation(this);
        this.violations += 1.0;
        return true;
    }

    public final boolean flagWithSetback() {
        if (this.flag()) {
            this.setbackIfAboveSetbackVL();
            return true;
        }
        return false;
    }

    public final void reward() {
        this.violations = Math.max(0.0, this.violations - this.decay);
    }

    @Override
    public void reload() {
        this.decay = this.getConfig().getDoubleElse(this.configName + ".decay", this.decay);
        this.setbackVL = this.getConfig().getDoubleElse(this.configName + ".setbackvl", this.setbackVL);
        if (this.setbackVL == -1.0) {
            this.setbackVL = Double.MAX_VALUE;
        }
    }

    public boolean alert(String verbose) {
        return this.player.punishmentManager.handleAlert(this.player, verbose, this);
    }

    public DynamicConfig getConfig() {
        return GrimAPI.INSTANCE.getConfigManager().getConfig();
    }

    public boolean setbackIfAboveSetbackVL() {
        if (this.getViolations() > this.setbackVL) {
            return this.player.getSetbackTeleportUtil().executeViolationSetback();
        }
        return false;
    }

    public String formatOffset(double offset) {
        return offset > 0.001 ? String.format("%.5f", offset) : String.format("%.2E", offset);
    }

    public GrimPlayer getPlayer() {
        return this.player;
    }

    @Override
    public double getViolations() {
        return this.violations;
    }

    @Override
    public double getDecay() {
        return this.decay;
    }

    @Override
    public double getSetbackVL() {
        return this.setbackVL;
    }

    @Override
    public String getCheckName() {
        return this.checkName;
    }

    @Override
    public String getConfigName() {
        return this.configName;
    }

    @Override
    public String getAlternativeName() {
        return this.alternativeName;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }
}

