/*
 * Decompiled with CFR 0.152.
 */
package ac.grim.grimac;

import ac.grim.grimac.AbstractCheck;
import ac.grim.grimac.GrimAPI;
import ac.grim.grimac.GrimAbstractAPI;
import ac.grim.grimac.GrimUser;
import ac.grim.grimac.manager.init.Initable;
import ac.grim.grimac.player.GrimPlayer;
import ac.grim.grimac.shaded.com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import ac.grim.grimac.shaded.io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import ac.grim.grimac.shaded.jetbrains.annotations.Nullable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class GrimExternalAPI
implements GrimAbstractAPI,
Initable {
    private final GrimAPI api;
    private final Map<String, Function<GrimUser, String>> variableReplacements = new ConcurrentHashMap<String, Function<GrimUser, String>>();

    public GrimExternalAPI(GrimAPI api) {
        this.api = api;
    }

    @Override
    @Nullable
    public GrimUser getGrimUser(Player player) {
        return this.api.getPlayerDataManager().getPlayer(player);
    }

    @Override
    public void setServerName(String name) {
        this.variableReplacements.put("%server%", user -> name);
    }

    public String replaceVariables(GrimUser user, String content, boolean colors) {
        if (colors) {
            content = ChatColor.translateAlternateColorCodes((char)'&', (String)content);
        }
        for (Map.Entry<String, Function<GrimUser, String>> entry : this.variableReplacements.entrySet()) {
            content = content.replace(entry.getKey(), entry.getValue().apply(user));
        }
        return content;
    }

    @Override
    public void registerVariable(String string, Function<GrimUser, String> replacement) {
        this.variableReplacements.put(string, replacement);
    }

    @Override
    public void reload() {
        GrimAPI.INSTANCE.getConfigManager().reload();
        for (GrimPlayer grimPlayer : GrimAPI.INSTANCE.getPlayerDataManager().getEntries()) {
            ChannelHelper.runInEventLoop(grimPlayer.user.getChannel(), () -> {
                grimPlayer.onReload();
                grimPlayer.updatePermissions();
                grimPlayer.punishmentManager.reload();
                for (AbstractCheck value : grimPlayer.checkManager.allChecks.values()) {
                    value.reload();
                }
            });
        }
        GrimAPI.INSTANCE.getDiscordManager().start();
        GrimAPI.INSTANCE.getSpectateManager().start();
        GrimAPI.INSTANCE.getExternalAPI().start();
    }

    @Override
    public void start() {
        this.variableReplacements.put("%player%", GrimUser::getName);
        this.variableReplacements.put("%uuid%", user -> user.getUniqueId().toString());
        this.variableReplacements.put("%ping%", user -> user.getTransactionPing() + "");
        this.variableReplacements.put("%brand%", GrimUser::getBrand);
        this.variableReplacements.put("%h_sensitivity%", user -> (int)Math.round(user.getHorizontalSensitivity() * 200.0) + "");
        this.variableReplacements.put("%v_sensitivity%", user -> (int)Math.round(user.getVerticalSensitivity() * 200.0) + "");
        this.variableReplacements.put("%fast_math%", user -> !user.isVanillaMath() + "");
        this.variableReplacements.put("%tps%", user -> String.format("%.2f", SpigotReflectionUtil.getTPS()));
        this.variableReplacements.put("%version%", GrimUser::getVersionName);
        this.variableReplacements.put("%prefix%", user -> ChatColor.translateAlternateColorCodes((char)'&', (String)GrimAPI.INSTANCE.getConfigManager().getConfig().getStringElse("prefix", "&bGrim &8\u00bb")));
    }

    public Map<String, Function<GrimUser, String>> getVariableReplacements() {
        return this.variableReplacements;
    }
}

