/*
 * Decompiled with CFR 0.152.
 */
package com.generator.GUI;

import com.generator.Utils.MessageUtils;
import com.generator.Utils.Utils;
import com.generator.config.ConfigManager;
import com.generator.main.generator;
import com.generator.protocol.ID;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class GUI
implements Listener {
    Player player;
    Inventory inv;

    public GUI(Player player) {
        this.player = player;
        generator.instance.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)generator.instance);
        this.inv = Bukkit.createInventory(null, (int)this.size(), (String)this.name());
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent e) {
        if (!e.getPlayer().hasPermission(this.permission())) {
            Utils.sendMessage(this.player, MessageUtils.INAVLID_PERMISSION);
            e.setCancelled(true);
            return;
        }
        this.onOpenInventory(e);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        this.onCloseInventory(e);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        e.setCancelled(!this.canTakeItems());
        if (e.getCurrentItem() == null) {
            return;
        }
        this.onClickInventory(e);
    }

    public abstract String name();

    public abstract String permission();

    public abstract int size();

    public abstract Sound sound();

    public abstract float soundLevel();

    public abstract boolean canTakeItems();

    public abstract void onClickInventory(InventoryClickEvent var1);

    public abstract void onOpenInventory(InventoryOpenEvent var1);

    public abstract void onCloseInventory(InventoryCloseEvent var1);

    public abstract void Contents(Inventory var1);

    public void setModule(String name, Material mat, String str, ID id, Player target) {
        FileConfiguration file = ConfigManager.getConfig((String)str).configuration;
        String defaults = String.valueOf(id.toString().toLowerCase()) + "." + name + ".";
        ItemStack stack = new ItemStack(mat);
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(Utils.getMessage(file.getString(String.valueOf(defaults) + "name").replace("%PLAYER%", target.getName())));
        ArrayList<String> lists = new ArrayList<String>();
        int i = 0;
        while (i < file.getStringList(String.valueOf(defaults) + "lore").size()) {
            lists.add(Utils.getMessage((String)file.getStringList(String.valueOf(defaults) + "lore").get(i)).replace("%PLAYER%", target.getName()));
            ++i;
        }
        meta.setLore(lists);
        stack.setItemMeta(meta);
        this.inv.setItem(file.getInt(String.valueOf(defaults) + "location"), stack);
        if (file.getString(String.valueOf(defaults) + "command_ON_OPEN") != null) {
            this.player.chat(file.getString(String.valueOf(defaults) + "command_ON_OPEN"));
        }
    }

    public void addExtItems(String str, ID id, Player target) {
        FileConfiguration file = ConfigManager.getConfig((String)str).configuration;
        String defaults = String.valueOf(id.toString().toLowerCase()) + ".";
        int i = 0;
        while (i < file.getStringList(String.valueOf(defaults) + "custom_block_place.fields").size()) {
            System.out.println(file.getString(String.valueOf(defaults) + "custom_block_place." + (String)file.getStringList(String.valueOf(defaults) + "custom_block_place.fields").get(i) + ".material"));
            ItemStack stack = new ItemStack(Material.valueOf((String)file.getString(String.valueOf(defaults) + "custom_block_place." + (String)file.getStringList(String.valueOf(defaults) + "custom_block_place.fields").get(i) + ".material")));
            ItemMeta meta = stack.getItemMeta();
            if (!file.getString(String.valueOf(defaults) + "custom_block_place." + (String)file.getStringList(String.valueOf(defaults) + "custom_block_place.fields").get(i) + ".enchanted").equals("null")) {
                meta.addEnchant(Enchantment.getByName((String)file.getString(String.valueOf(defaults) + "custom_block_place." + (String)file.getStringList(String.valueOf(defaults) + "custom_block_place.fields").get(i) + ".enchanted")), 1, true);
            }
            meta.setDisplayName(Utils.getMessage(file.getString(String.valueOf(defaults) + "custom_block_place." + (String)file.getStringList(String.valueOf(defaults) + "custom_block_place.fields").get(i) + ".name").replace("%PLAYER%", target.getName())));
            ArrayList<String> lists = new ArrayList<String>();
            int v = 0;
            while (v < file.getStringList(String.valueOf(defaults) + "custom_block_place." + (String)file.getStringList(String.valueOf(defaults) + "custom_block_place.fields").get(i) + ".lore").size()) {
                lists.add(Utils.getMessage((String)file.getStringList(String.valueOf(defaults) + "custom_block_place." + (String)file.getStringList(String.valueOf(defaults) + "custom_block_place.fields").get(i) + ".lore").get(v)).replace("%PLAYER%", target.getName()));
                ++v;
            }
            meta.setLore(lists);
            stack.setItemMeta(meta);
            this.inv.setItem(file.getInt(String.valueOf(defaults) + "custom_block_place." + (String)file.getStringList(String.valueOf(defaults) + "custom_block_place.fields").get(i) + ".location"), stack);
            ++i;
        }
    }

    public void setModule(String name, ItemStack mat, String str, ID id, Player target) {
        FileConfiguration file = ConfigManager.getConfig((String)str).configuration;
        String defaults = String.valueOf(id.toString().toLowerCase()) + "." + name + ".";
        int i = 0;
        while (i < file.getInt(String.valueOf(defaults) + "custom_block_place.size")) {
            ItemStack stack = new ItemStack(Material.valueOf((String)file.getString(String.valueOf(defaults) + "custom_block_place." + i + ".Material")));
            ItemMeta meta = stack.getItemMeta();
            if (!file.getString(String.valueOf(defaults) + "custom_block_place.Enchanted").equals("null")) {
                meta.addEnchant(Enchantment.getByName((String)file.getString(String.valueOf(defaults) + "custom_block_place." + i + ".Enchanted")), 1, true);
            }
            meta.setDisplayName(Utils.getMessage(file.getString(String.valueOf(defaults) + "custom_block_place." + i + ".name").replace("%PLAYER%", target.getName())));
            ArrayList<String> lists = new ArrayList<String>();
            int v = 0;
            while (v < file.getStringList(String.valueOf(defaults) + "lore").size()) {
                lists.add(Utils.getMessage((String)file.getStringList(String.valueOf(defaults) + "custom_block_place." + i + ".lore").get(v)).replace("%PLAYER%", target.getName()));
                ++v;
            }
            meta.setLore(lists);
            stack.setItemMeta(meta);
            this.inv.setItem(file.getInt(String.valueOf(defaults) + "custom_block_place." + i + ".location"), stack);
            if (file.getString(String.valueOf(defaults) + "custom_block_place." + i + ".command_ON_OPEN") != null) {
                this.player.chat(file.getString(String.valueOf(defaults) + "custom_block_place." + i + ".command_ON_OPEN"));
            }
            ++i;
        }
        ItemStack stack = mat;
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(Utils.getMessage(file.getString(String.valueOf(defaults) + "name").replace("%PLAYER%", target.getName())));
        ArrayList<String> lists = new ArrayList<String>();
        int i2 = 0;
        while (i2 < file.getStringList(String.valueOf(defaults) + "lore").size()) {
            lists.add(Utils.getMessage(((String)file.getStringList(String.valueOf(defaults) + "lore").get(i2)).replace("%PLAYER%", target.getName())));
            ++i2;
        }
        meta.setLore(lists);
        stack.setItemMeta(meta);
        this.inv.setItem(file.getInt(String.valueOf(defaults) + "location"), stack);
        if (file.getString(String.valueOf(defaults) + "command_ON_OPEN") != null) {
            this.player.chat(file.getString(String.valueOf(defaults) + "command_ON_OPEN"));
        }
    }

    public void open() {
        this.player.getWorld().playSound(this.player.getLocation(), this.sound(), this.soundLevel(), this.soundLevel());
        this.Contents(this.inv);
        this.player.openInventory(this.inv);
    }

    public void addItem(int index, ItemStack item) {
        this.inv.setItem(index, item);
    }
}

