/*
 * Decompiled with CFR 0.152.
 */
package xyz.trrlgn.gamblebarlite.bar;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import xyz.trrlgn.gamblebarlite.GambleBar;

public class BarManager {
    public GambleBar plugin;
    public Inventory inv;
    public ArrayList<ItemStack> drinks = new ArrayList();
    public ArrayList<Integer> rewards = new ArrayList();
    public ArrayList<Double> odds = new ArrayList();

    public BarManager(GambleBar pl) {
        this.plugin = pl;
    }

    public void loadBar() {
        this.inv = Bukkit.createInventory(null, (int)9, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("barTitle")));
        for (int i = 0; i < 9; ++i) {
            if (!this.plugin.getConfig().contains("bar." + i + ".name")) continue;
            ItemStack drink = new ItemStack(Material.POTION);
            ItemMeta drinkMeta = drink.getItemMeta();
            drinkMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("bar." + i + ".name")));
            ArrayList<String> lore = new ArrayList<String>();
            for (String itemLore : this.plugin.getConfig().getStringList("bar." + i + ".lore")) {
                String p = String.format("%,d", this.plugin.getConfig().getInt("bar." + i + ".price"));
                String r = String.format("%,d", this.plugin.getConfig().getInt("bar." + i + ".reward"));
                String o = String.format("%.2f", this.plugin.getConfig().getDouble("bar." + i + ".odds"));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)itemLore.replaceAll("%odds%", o).replaceAll("%price%", p).replaceAll("%reward%", r)));
            }
            drinkMeta.setLore(lore);
            drinkMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
            drink.setItemMeta(drinkMeta);
            this.inv.addItem(new ItemStack[]{drink});
            this.drinks.add(drink);
            this.rewards.add(this.plugin.getConfig().getInt("bar." + i + ".reward"));
            this.odds.add(this.plugin.getConfig().getDouble("bar." + i + ".odds"));
        }
    }

    public void openBar(Player p) {
        if (p.hasPermission("gamblebar.open")) {
            p.openInventory(this.inv);
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.pmessages.getString("openedBar")));
        } else {
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.pmessages.getString("noPermission")));
        }
    }
}

