/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.world.palette;

import java.util.List;
import java.util.Random;
import org.polydev.gaea.math.FastNoiseLite;
import org.polydev.gaea.math.ProbabilityCollection;
import org.polydev.gaea.util.GlueList;

public abstract class Palette<E> {
    private final List<PaletteLayer<E>> pallet = new GlueList<PaletteLayer<E>>();

    public Palette<E> add(E m, int layers) {
        for (int i = 0; i < layers; ++i) {
            this.pallet.add(new PaletteLayer<E>(m));
        }
        return this;
    }

    public Palette<E> add(ProbabilityCollection<E> m, int layers) {
        for (int i = 0; i < layers; ++i) {
            this.pallet.add(new PaletteLayer<ProbabilityCollection<E>>(m));
        }
        return this;
    }

    public abstract E get(int var1, int var2, int var3);

    public int getSize() {
        return this.pallet.size();
    }

    public List<PaletteLayer<E>> getLayers() {
        return this.pallet;
    }

    public static class PaletteLayer<E> {
        private final boolean col;
        private ProbabilityCollection<E> collection;
        private E m;

        public PaletteLayer(ProbabilityCollection<E> type) {
            this.col = true;
            this.collection = type;
        }

        public PaletteLayer(E type) {
            this.col = false;
            this.m = type;
        }

        public E get(Random random) {
            if (this.col) {
                return this.collection.get(random);
            }
            return this.m;
        }

        public E get(FastNoiseLite random, int x, int z) {
            if (this.col) {
                return this.collection.get(random, x, z);
            }
            return this.m;
        }

        public ProbabilityCollection<E> getCollection() {
            return this.collection;
        }
    }
}

