/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.world.carving;

import java.util.Random;
import java.util.function.BiConsumer;
import org.bukkit.World;
import org.bukkit.util.Vector;
import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.math.MathUtil;
import org.polydev.gaea.util.FastRandom;
import org.polydev.gaea.world.carving.Worm;

public abstract class Carver {
    private final int minY;
    private final int maxY;
    private final double sixtyFourSq = FastMath.pow(64.0, 2.0);
    private int carvingRadius = 4;

    public Carver(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
    }

    public void carve(int chunkX, int chunkZ, World w, BiConsumer<Vector, CarvingType> consumer) {
        for (int x = chunkX - this.carvingRadius; x <= chunkX + this.carvingRadius; ++x) {
            block1: for (int z = chunkZ - this.carvingRadius; z <= chunkZ + this.carvingRadius; ++z) {
                if (!this.isChunkCarved(w, x, z, new FastRandom(MathUtil.hashToLong(this.getClass().getName() + "_" + x + "&" + z)))) continue;
                long seed = MathUtil.getCarverChunkSeed(x, z, w.getSeed());
                FastRandom r = new FastRandom(seed);
                Worm carving = this.getWorm(seed, new Vector((x << 4) + ((Random)r).nextInt(16), ((Random)r).nextInt(this.maxY - this.minY + 1) + this.minY, (z << 4) + ((Random)r).nextInt(16)));
                Vector origin = carving.getOrigin();
                for (int i = 0; i < carving.getLength(); ++i) {
                    carving.step();
                    if (carving.getRunning().clone().setY(0).distanceSquared(origin.clone().setY(0)) > this.sixtyFourSq) continue block1;
                    if (FastMath.floorDiv(origin.getBlockX(), 16) != chunkX && FastMath.floorDiv(origin.getBlockZ(), 16) != chunkZ) continue;
                    carving.getPoint().carve(chunkX, chunkZ, consumer);
                }
            }
        }
    }

    public int getCarvingRadius() {
        return this.carvingRadius;
    }

    public void setCarvingRadius(int carvingRadius) {
        this.carvingRadius = carvingRadius;
    }

    public abstract Worm getWorm(long var1, Vector var3);

    public abstract boolean isChunkCarved(World var1, int var2, int var3, Random var4);

    public static enum CarvingType {
        CENTER,
        WALL,
        TOP,
        BOTTOM;

    }
}

