/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.world;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.polydev.gaea.math.Range;
import org.polydev.gaea.util.GlueList;
import org.polydev.gaea.world.Flora;

public enum FloraType implements Flora
{
    TALL_GRASS(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:tall_grass[half=lower]"), Bukkit.createBlockData((String)"minecraft:tall_grass[half=upper]")),
    TALL_FERN(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:large_fern[half=lower]"), Bukkit.createBlockData((String)"minecraft:large_fern[half=upper]")),
    SUNFLOWER(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:sunflower[half=lower]"), Bukkit.createBlockData((String)"minecraft:sunflower[half=upper]")),
    ROSE_BUSH(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:rose_bush[half=lower]"), Bukkit.createBlockData((String)"minecraft:rose_bush[half=upper]")),
    LILAC(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:lilac[half=lower]"), Bukkit.createBlockData((String)"minecraft:lilac[half=upper]")),
    PEONY(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:peony[half=lower]"), Bukkit.createBlockData((String)"minecraft:peony[half=upper]")),
    GRASS(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:grass")),
    FERN(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:fern")),
    AZURE_BLUET(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:azure_bluet")),
    LILY_OF_THE_VALLEY(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:lily_of_the_valley")),
    BLUE_ORCHID(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:blue_orchid")),
    POPPY(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:poppy")),
    DANDELION(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:dandelion")),
    WITHER_ROSE(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:wither_rose")),
    DEAD_BUSH(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL, Material.SAND, Material.RED_SAND, Material.TERRACOTTA, Material.BLACK_TERRACOTTA, Material.BLUE_TERRACOTTA, Material.BROWN_TERRACOTTA, Material.CYAN_TERRACOTTA, Material.GRAY_TERRACOTTA, Material.GREEN_TERRACOTTA, Material.LIGHT_BLUE_TERRACOTTA, Material.LIGHT_GRAY_TERRACOTTA, Material.LIME_TERRACOTTA, Material.MAGENTA_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.PINK_TERRACOTTA, Material.PURPLE_TERRACOTTA, Material.RED_TERRACOTTA, Material.RED_TERRACOTTA, Material.WHITE_TERRACOTTA, Material.YELLOW_TERRACOTTA}), Bukkit.createBlockData((String)"minecraft:dead_bush")),
    RED_TULIP(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:red_tulip")),
    ORANGE_TULIP(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:orange_tulip")),
    WHITE_TULIP(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:white_tulip")),
    PINK_TULIP(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:pink_tulip")),
    OXEYE_DAISY(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:oxeye_daisy")),
    ALLIUM(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:allium")),
    CORNFLOWER(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL}), Bukkit.createBlockData((String)"minecraft:cornflower")),
    LILY_PAD(Sets.newHashSet((Object[])new Material[]{Material.WATER}), Bukkit.createBlockData((String)"minecraft:lily_pad")),
    RED_MUSHROOM(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL, Material.DIRT, Material.STONE, Material.NETHERRACK, Material.MYCELIUM}), Bukkit.createBlockData((String)"minecraft:red_mushroom")),
    BROWN_MUSHROOM(Sets.newHashSet((Object[])new Material[]{Material.GRASS_BLOCK, Material.PODZOL, Material.DIRT, Material.STONE, Material.NETHERRACK, Material.MYCELIUM}), Bukkit.createBlockData((String)"minecraft:brown_mushroom"));

    private final List<BlockData> data = new GlueList<BlockData>();
    private final Set<Material> spawns;

    private FloraType(Set<Material> validSpawns, BlockData ... type) {
        this.data.addAll(Arrays.asList(type));
        this.spawns = validSpawns;
    }

    @Override
    public List<Block> getValidSpawnsAt(Chunk chunk, int x, int z, Range check) {
        GlueList<Block> blocks = new GlueList<Block>();
        for (int y : check) {
            Block block = chunk.getBlock(x, y, z);
            if (!this.spawns.contains(block.getType()) || !this.valid(block)) continue;
            blocks.add(chunk.getBlock(x, y, z));
        }
        return blocks;
    }

    private boolean valid(Block block) {
        for (int i = 1; i < this.data.size() + 1; ++i) {
            if ((block = block.getRelative(BlockFace.UP)).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean plant(Location l) {
        for (int i = 1; i < this.data.size() + 1; ++i) {
            l.clone().add(0.0, (double)i, 0.0).getBlock().setBlockData(this.data.get(i - 1), false);
        }
        return true;
    }
}

