/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.polydev.gaea.Debug;

public class JarUtil {
    public static void copyResourcesToDirectory(JarFile fromJar, String sourceDir, String destDir) throws IOException {
        Enumeration<JarEntry> entries = fromJar.entries();
        while (entries.hasMoreElements()) {
            File dest;
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(sourceDir + "/") || entry.isDirectory() || (dest = new File(destDir + File.separator + entry.getName().substring(sourceDir.length() + 1))).exists()) continue;
            File parent = dest.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            Debug.info("Output does not already exist. Creating... ");
            try {
                FileOutputStream out = new FileOutputStream(dest);
                Throwable throwable = null;
                try {
                    InputStream in = fromJar.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        int s;
                        byte[] buffer = new byte[8192];
                        while ((s = in.read(buffer)) > 0) {
                            out.write(buffer, 0, s);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException e) {
                throw new IOException("Could not copy asset from jar file", e);
            }
        }
    }
}

