/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.tree.fractal.trees;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.util.Vector;
import org.polydev.gaea.tree.fractal.FractalTree;
import org.polydev.gaea.tree.fractal.TreeGeometry;

public class SpruceTree
extends FractalTree {
    private final TreeGeometry geo = new TreeGeometry(this);

    public SpruceTree(Location origin, Random random) {
        super(origin, random);
    }

    @Override
    public void grow() {
        this.growTrunk(super.getOrigin().clone(), new Vector(0, 16 + super.getRandom().nextInt(5), 0));
    }

    private void growTrunk(Location l1, Vector diff) {
        if (diff.getY() < 0.0) {
            diff.rotateAroundAxis(TreeGeometry.getPerpendicular(diff.clone()).normalize(), Math.PI);
        }
        int d = (int)diff.length();
        int rad = 7;
        for (int i = 0; i < d; ++i) {
            this.geo.generateSphere(l1.clone().add(diff.clone().multiply((double)i / (double)d)), Material.SPRUCE_WOOD, (int)((double)i > (double)d * 0.65 ? 0.5 : 1.5), true);
            if (i <= 3) continue;
            this.geo.generateCylinder(l1.clone().add(diff.clone().multiply((double)i / (double)d)), Material.SPRUCE_LEAVES, (int)((double)(6 - i % 4) * (1.25 - (double)i / (double)d)), 1, false);
        }
        this.setBlock(l1.clone().add(diff), Material.SPRUCE_LEAVES);
        this.setBlock(l1.clone().add(diff).add(0.0, 1.0, 0.0), Material.SPRUCE_LEAVES);
    }
}

