/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.tree.fractal.trees;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.polydev.gaea.math.FastNoiseLite;
import org.polydev.gaea.math.ProbabilityCollection;
import org.polydev.gaea.tree.fractal.FractalTree;
import org.polydev.gaea.tree.fractal.TreeGeometry;

public class Rock
extends FractalTree {
    private final TreeGeometry geo;
    private final FastNoiseLite noise;
    private final FastNoiseLite rock;
    private static final ProbabilityCollection<Material> ice = new ProbabilityCollection<Material>().add(Material.PACKED_ICE, 95).add(Material.BLUE_ICE, 5);

    public Rock(Location origin, Random random) {
        super(origin, random);
        int seed = origin.hashCode();
        this.noise = new FastNoiseLite(seed);
        this.rock = new FastNoiseLite(++seed);
        this.geo = new TreeGeometry(this);
    }

    @Override
    public void grow() {
        int i;
        Location l1 = super.getOrigin().clone();
        int h = super.getRandom().nextInt(16) + 8;
        for (i = 0; i < h; ++i) {
            this.geo.generateSponge(l1.clone().add(0.0, (double)i, 0.0), ice, (int)((1.0 - (double)i / (double)h) * 2.0 + 1.0), true, 70);
        }
        for (i = 0; i < h / 3; ++i) {
            this.setBlock(l1.clone().add(0.0, (double)(h + i), 0.0), ice.get(super.getRandom()));
        }
    }
}

