/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.tree.fractal.trees;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.util.Vector;
import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.tree.fractal.FractalTree;
import org.polydev.gaea.tree.fractal.TreeGeometry;

public class OakTree
extends FractalTree {
    private final TreeGeometry geo = new TreeGeometry(this);

    public OakTree(Location origin, Random random) {
        super(origin, random);
    }

    @Override
    public void grow() {
        this.growBranch(super.getOrigin().clone(), new Vector(super.getRandom().nextInt(5) - 2, super.getRandom().nextInt(4) + 6, super.getRandom().nextInt(5) - 2), 2.0, 0);
    }

    private void growBranch(Location l1, Vector diff, double d1, int recursions) {
        if (recursions > 1) {
            this.geo.generateSphere(l1, Material.OAK_LEAVES, 1 + super.getRandom().nextInt(2) + (3 - recursions), false);
            if (recursions > 2) {
                return;
            }
        }
        if (diff.getY() < 0.0) {
            diff.rotateAroundAxis(TreeGeometry.getPerpendicular(diff.clone()).normalize(), Math.PI);
        }
        int d = (int)diff.length();
        for (int i = 0; i < d; ++i) {
            this.geo.generateSphere(l1.clone().add(diff.clone().multiply((double)i / (double)d)), Material.OAK_WOOD, FastMath.max((int)d1, 0), true);
        }
        double runningAngle = 45.0 / (double)(recursions + 1);
        this.growBranch(l1.clone().add(diff), diff.clone().multiply(0.75).rotateAroundX(FastMath.toRadians(runningAngle + (double)this.getNoise())).rotateAroundZ(FastMath.toRadians(this.getNoise())), d1 - 1.0, recursions + 1);
        this.growBranch(l1.clone().add(diff), diff.clone().multiply(0.75).rotateAroundX(FastMath.toRadians(-runningAngle + (double)this.getNoise())).rotateAroundZ(FastMath.toRadians(this.getNoise())), d1 - 1.0, recursions + 1);
        this.growBranch(l1.clone().add(diff), diff.clone().multiply(0.75).rotateAroundZ(FastMath.toRadians(runningAngle + (double)this.getNoise())).rotateAroundX(FastMath.toRadians(this.getNoise())), d1 - 1.0, recursions + 1);
        this.growBranch(l1.clone().add(diff), diff.clone().multiply(0.75).rotateAroundZ(FastMath.toRadians(-runningAngle + (double)this.getNoise())).rotateAroundX(FastMath.toRadians(this.getNoise())), d1 - 1.0, recursions + 1);
    }

    private int getNoise() {
        return super.getRandom().nextInt(60) - 30;
    }
}

