/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.tree.fractal.trees;

import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.util.Vector;
import org.polydev.gaea.math.ProbabilityCollection;
import org.polydev.gaea.tree.fractal.FractalTree;
import org.polydev.gaea.tree.fractal.TreeGeometry;

public class IceSpike
extends FractalTree {
    private final TreeGeometry geo = new TreeGeometry(this);
    private static final ProbabilityCollection<Material> ice = new ProbabilityCollection<Material>().add(Material.PACKED_ICE, 95).add(Material.BLUE_ICE, 5);

    public IceSpike(Location origin, Random random) {
        super(origin, random);
    }

    private double getOffset() {
        return this.getRandom().nextDouble() - 0.5;
    }

    @Override
    public void grow() {
        int i;
        Vector direction = new Vector(this.getOffset(), 0.0, this.getOffset());
        Location l1 = super.getOrigin().clone();
        int h = super.getRandom().nextInt(16) + 8;
        for (i = 0; i < h; ++i) {
            this.geo.generateSponge(l1.clone().add(0.0, (double)i, 0.0).add(direction.clone().multiply(i)), ice, (int)((1.0 - (double)i / (double)h) * 2.0 + 1.0), true, 80);
        }
        for (i = 0; i < h / 3; ++i) {
            this.setBlock(l1.clone().add(0.0, (double)(h + i), 0.0).add(direction.clone().multiply(h + i)), ice.get(super.getRandom()));
        }
    }
}

