/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.tree.fractal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.util.Consumer;
import org.polydev.gaea.tree.fractal.EntitySpawnHolder;
import org.polydev.gaea.util.GlueList;

public abstract class FractalTree {
    private final Map<Location, BlockData> treeAssembler = new HashMap<Location, BlockData>();
    private final List<EntitySpawnHolder> entities = new GlueList<EntitySpawnHolder>();
    private final Location origin;
    private final Random random;
    private final List<Material> replaceable = Arrays.asList(Material.AIR, Material.GRASS_BLOCK, Material.DIRT, Material.STONE, Material.COARSE_DIRT, Material.GRAVEL, Material.PODZOL, Material.GRASS, Material.TALL_GRASS, Material.FERN, Material.POPPY, Material.LARGE_FERN, Material.BLUE_ORCHID, Material.AZURE_BLUET, Material.END_STONE, Material.SNOW, Material.SAND, Material.STONE_BUTTON, Material.DEAD_BUSH);

    public FractalTree(Location origin, Random random) {
        this.origin = origin.add(0.0, 1.0, 0.0);
        this.random = random;
    }

    public Map<Location, BlockData> getTree() {
        return this.treeAssembler;
    }

    public Random getRandom() {
        return this.random;
    }

    public Location getOrigin() {
        return this.origin;
    }

    public void setBlock(Location l, Material m) {
        this.treeAssembler.put(l, m.createBlockData());
    }

    public abstract void grow();

    public void plant() {
        for (Map.Entry<Location, BlockData> entry : this.treeAssembler.entrySet()) {
            if (!this.replaceable.contains(entry.getKey().getBlock().getType())) continue;
            entry.getKey().getBlock().setBlockData(entry.getValue(), false);
        }
        for (EntitySpawnHolder e : this.entities) {
            Objects.requireNonNull(e.getLocation().getWorld()).spawn(e.getLocation(), e.getEntity(), e.getConsumer());
        }
    }

    public void spawnEntity(Location spawn, Class clazz, Consumer<Entity> consumer) {
        this.entities.add(new EntitySpawnHolder(spawn, clazz, consumer));
    }

    public Material getMaterial(Location l) {
        return this.treeAssembler.getOrDefault(l, Material.AIR.createBlockData()).getMaterial();
    }
}

