/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.structures.loot.functions;

import java.util.Collections;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONArray;
import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.structures.loot.functions.Function;
import org.polydev.gaea.util.GlueList;

public class EnchantWithLevelsFunction
implements Function {
    private final int min;
    private final int max;
    private final JSONArray disabled;

    public EnchantWithLevelsFunction(int min, int max, JSONArray disabled) {
        this.max = max;
        this.min = min;
        this.disabled = disabled;
    }

    @Override
    public ItemStack apply(ItemStack original, Random r) {
        double enchant = r.nextDouble() * (double)(this.max - this.min) + (double)this.min;
        GlueList possible = new GlueList();
        for (Enchantment ench : Enchantment.values()) {
            if (!ench.canEnchantItem(original) || this.disabled != null && this.disabled.contains(ench.getName())) continue;
            possible.add(ench);
        }
        int numEnchant = r.nextInt((int)FastMath.abs(enchant)) / 10 + 1;
        if (possible.size() >= numEnchant) {
            Collections.shuffle(possible);
            block3: for (int i = 0; i < numEnchant; ++i) {
                Enchantment chosen = (Enchantment)possible.get(i);
                for (Enchantment ench : original.getEnchantments().keySet()) {
                    if (!chosen.conflictsWith(ench)) continue;
                    continue block3;
                }
                int lvl = r.nextInt(1 + (int)((enchant / 40.0 > 1.0 ? 1.0 : enchant / 40.0) * (double)chosen.getMaxLevel()));
                try {
                    original.addEnchantment(chosen, FastMath.max(lvl, 1));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Bukkit.getLogger().warning("[Gaea] Attempted to enchant " + original.getType() + " with " + chosen + " at level " + FastMath.max(lvl, 1) + ", but an unexpected exception occurred! Usually this is caused by a misbehaving enchantment plugin.");
                }
            }
        }
        return original;
    }
}

