/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.structures.loot;

import java.util.List;
import java.util.Random;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.math.ProbabilityCollection;
import org.polydev.gaea.structures.loot.Entry;
import org.polydev.gaea.util.GlueList;

public class Pool {
    private final int max;
    private final int min;
    private final ProbabilityCollection<Entry> entries = new ProbabilityCollection();

    public Pool(JSONObject pool) {
        Object amount = pool.get("rolls");
        if (amount instanceof Long) {
            this.max = FastMath.toIntExact((Long)amount);
            this.min = FastMath.toIntExact((Long)amount);
        } else {
            this.max = FastMath.toIntExact((Long)((JSONObject)amount).get("max"));
            this.min = FastMath.toIntExact((Long)((JSONObject)amount).get("min"));
        }
        for (Object entryJSON : (JSONArray)pool.get("entries")) {
            Entry entry = new Entry((JSONObject)entryJSON);
            this.entries.add(entry, FastMath.toIntExact(entry.getWeight()));
        }
    }

    public List<ItemStack> getItems(Random r) {
        int rolls = r.nextInt(this.max - this.min + 1) + this.min;
        GlueList<ItemStack> items = new GlueList<ItemStack>();
        for (int i = 0; i < rolls; ++i) {
            items.add(this.entries.get(r).getItem(r));
        }
        return items;
    }
}

