/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.structures.loot;

import java.util.List;
import java.util.Random;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.polydev.gaea.structures.loot.Pool;
import org.polydev.gaea.util.GlueList;

public class LootTable {
    private final List<Pool> pools = new GlueList<Pool>();

    public LootTable(String json) throws ParseException {
        JSONParser jsonParser = new JSONParser();
        Object tableJSON = jsonParser.parse(json);
        JSONArray poolArray = (JSONArray)((JSONObject)tableJSON).get("pools");
        for (Object pool : poolArray) {
            this.pools.add(new Pool((JSONObject)pool));
        }
    }

    public List<ItemStack> getLoot(Random r) {
        GlueList<ItemStack> itemList = new GlueList<ItemStack>();
        for (Pool pool : this.pools) {
            itemList.addAll(pool.getItems(r));
        }
        return itemList;
    }

    public void fillInventory(Inventory i, Random r) {
        List<ItemStack> loot = this.getLoot(r);
        for (ItemStack stack : loot) {
            for (int attempts = 0; stack.getAmount() != 0 && attempts < 10; ++attempts) {
                ItemStack newStack = stack.clone();
                newStack.setAmount(1);
                int slot = r.nextInt(i.getSize());
                ItemStack slotItem = i.getItem(slot);
                if (slotItem == null) {
                    i.setItem(slot, newStack);
                    stack.setAmount(stack.getAmount() - 1);
                    continue;
                }
                if (slotItem.getType() != newStack.getType()) continue;
                ItemStack dep = newStack.clone();
                dep.setAmount(newStack.getAmount() + slotItem.getAmount());
                i.setItem(slot, dep);
                stack.setAmount(stack.getAmount() - 1);
            }
        }
    }
}

