/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.structures.loot;

import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.structures.loot.functions.AmountFunction;
import org.polydev.gaea.structures.loot.functions.DamageFunction;
import org.polydev.gaea.structures.loot.functions.EnchantWithLevelsFunction;
import org.polydev.gaea.structures.loot.functions.Function;
import org.polydev.gaea.util.GlueList;

public class Entry {
    private final Material item;
    private final long weight;
    private final List<Function> functions = new GlueList<Function>();

    public Entry(JSONObject entry) {
        long weight1;
        String id = entry.get("name").toString();
        this.item = Material.matchMaterial((String)id);
        try {
            weight1 = (Long)entry.get("weight");
        }
        catch (NullPointerException e) {
            weight1 = 1L;
        }
        this.weight = weight1;
        if (entry.containsKey("functions")) {
            for (Object function : (JSONArray)entry.get("functions")) {
                switch ((String)((JSONObject)function).get("function")) {
                    case "minecraft:set_count": 
                    case "set_count": {
                        long min;
                        long max;
                        Object loot = ((JSONObject)function).get("count");
                        if (loot instanceof Long) {
                            max = (Long)loot;
                            min = (Long)loot;
                        } else {
                            max = (Long)((JSONObject)loot).get("max");
                            min = (Long)((JSONObject)loot).get("min");
                        }
                        this.functions.add(new AmountFunction(FastMath.toIntExact(min), FastMath.toIntExact(max)));
                        break;
                    }
                    case "minecraft:set_damage": 
                    case "set_damage": {
                        long maxDamage = (Long)((JSONObject)((JSONObject)function).get("damage")).get("max");
                        long minDamage = (Long)((JSONObject)((JSONObject)function).get("damage")).get("min");
                        this.functions.add(new DamageFunction(FastMath.toIntExact(minDamage), FastMath.toIntExact(maxDamage)));
                        break;
                    }
                    case "minecraft:enchant_with_levels": 
                    case "enchant_with_levels": {
                        long maxEnchant = (Long)((JSONObject)((JSONObject)function).get("levels")).get("max");
                        long minEnchant = (Long)((JSONObject)((JSONObject)function).get("levels")).get("min");
                        JSONArray disabled = null;
                        if (((JSONObject)function).containsKey("disabled_enchants")) {
                            disabled = (JSONArray)((JSONObject)function).get("disabled_enchants");
                        }
                        this.functions.add(new EnchantWithLevelsFunction(FastMath.toIntExact(minEnchant), FastMath.toIntExact(maxEnchant), disabled));
                    }
                }
            }
        }
    }

    public ItemStack getItem(Random r) {
        ItemStack item = new ItemStack(this.item, 1);
        for (Function f : this.functions) {
            item = f.apply(item, r);
        }
        return item;
    }

    public long getWeight() {
        return this.weight;
    }
}

