/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.structures.features;

import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.polydev.gaea.structures.NMSStructure;
import org.polydev.gaea.structures.features.Feature;
import org.polydev.gaea.util.WorldUtil;

public class EntityFeature
implements Feature {
    private final int min;
    private final int max;
    private final EntityType type;

    public EntityFeature(int min, int max, EntityType entity) {
        this.max = max;
        this.min = min;
        this.type = entity;
    }

    @Override
    public void populate(NMSStructure s, Random r) {
        int num = r.nextInt(this.max - this.min + 1) + this.min;
        List<Location> all = WorldUtil.getLocationListBetween(s.getBoundingLocations()[0], s.getBoundingLocations()[1]);
        for (int i = 0; i < num; ++i) {
            boolean done = false;
            for (int attempts = 0; !done && attempts < 8; ++attempts) {
                Location candidate = all.get(r.nextInt(all.size()));
                if (!candidate.getBlock().isEmpty()) continue;
                candidate.getWorld().spawnEntity(candidate, this.type);
                done = true;
            }
        }
    }
}

