/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.structures.features;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.polydev.gaea.math.ProbabilityCollection;
import org.polydev.gaea.structures.NMSStructure;
import org.polydev.gaea.structures.features.Feature;
import org.polydev.gaea.util.WorldUtil;

public class BlockReplaceFeature
implements Feature {
    private final ProbabilityCollection<Material> materials;
    private final double percent;
    private final List<Material> replaceable = Arrays.asList(Material.COBBLESTONE, Material.COBBLESTONE_STAIRS, Material.COBBLESTONE_SLAB, Material.COBBLESTONE_WALL, Material.STONE_BRICK_SLAB, Material.STONE_BRICK_STAIRS, Material.STONE_BRICK_WALL, Material.STONE_BRICKS, Material.OAK_WOOD, Material.OAK_LOG, Material.OAK_PLANKS, Material.OAK_FENCE, Material.OAK_FENCE_GATE, Material.OAK_SLAB, Material.OAK_STAIRS, Material.SPRUCE_FENCE, Material.SPRUCE_FENCE_GATE, Material.SPRUCE_LOG, Material.SPRUCE_PLANKS, Material.SPRUCE_SLAB, Material.SPRUCE_STAIRS);

    public BlockReplaceFeature(double percent, ProbabilityCollection<Material> materials) {
        this.materials = materials;
        this.percent = percent;
    }

    @Override
    public void populate(NMSStructure s, Random r) {
        List<Location> all = WorldUtil.getLocationListBetween(s.getBoundingLocations()[0], s.getBoundingLocations()[1]);
        int i = 0;
        while ((double)i < (double)all.size() * (this.percent / 100.0)) {
            boolean done = false;
            for (int attempts = 0; !done && attempts < 5; ++attempts) {
                Location candidate = all.get(r.nextInt(all.size()));
                if (!this.replaceable.contains(candidate.getBlock().getType())) continue;
                candidate.getBlock().setType(this.materials.get(r));
                done = true;
            }
            ++i;
        }
    }
}

