/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.structures;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.polydev.gaea.libs.reflectasm.reflectasm.ConstructorAccess;
import org.polydev.gaea.libs.reflectasm.reflectasm.MethodAccess;
import org.polydev.gaea.util.FastRandom;

public class NMSStructure {
    private static final String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    public static int pasteMethodIndex;
    public static int getNBTListMethodIndex;
    private static Class definedStructureClass;
    private static MethodAccess definedStructureMethodAccess;
    private static ConstructorAccess<?> definedStructureConstructorAccess;
    private static int loadStructureMethodIndex;
    private static int getStructureAsNBTMethodIndex;
    private static MethodAccess nbtStreamToolsAccess;
    private static int loadNBTStreamFromInputStreamIndex;
    private static ConstructorAccess<?> compoundNBTConstructorAccess;
    private static MethodAccess compoundNBTTagMethodAccess;
    private static MethodAccess listNBTTagMethodAccess;
    private static int getNBTListItemMethodIndex;
    private static MethodAccess enumBlockRotationMethodAccess;
    private static int enumBlockRotationValueOfIndex;
    private static MethodAccess craftWorldMethodAccess;
    private static int getCraftWorldHandleIndex;
    private static MethodAccess definedStructureInfoMethodAccess;
    private static int setRotationMethodIndex;
    private static ConstructorAccess<?> definedStructureInfoConstructorAccess;
    private static int mysteryBooleanMethodIndex;
    private static int chunkCoordIntPairMethodIndex;
    private static int mysteryBooleancMethodIndex;
    private static int setRandomMethodIndex;
    private static MethodAccess craftBlockMethodAccess;
    private static int craftBlockGetPositionIndex;
    private int[] dimension;
    private Object structure;
    private Location origin;
    private int rotation = 0;

    @Deprecated
    public NMSStructure(Location origin, InputStream file) {
        try {
            Object structure = definedStructureConstructorAccess.newInstance();
            definedStructureMethodAccess.invoke(structure, loadStructureMethodIndex, nbtStreamToolsAccess.invoke(null, loadNBTStreamFromInputStreamIndex, file));
            Object tag = definedStructureMethodAccess.invoke(structure, getStructureAsNBTMethodIndex, compoundNBTConstructorAccess.newInstance());
            Object dimTag = compoundNBTTagMethodAccess.invoke(tag, getNBTListMethodIndex, "size", 3);
            this.dimension = new int[]{(Integer)listNBTTagMethodAccess.invoke(dimTag, getNBTListItemMethodIndex, 0), (Integer)listNBTTagMethodAccess.invoke(dimTag, getNBTListItemMethodIndex, 1), (Integer)listNBTTagMethodAccess.invoke(dimTag, getNBTListItemMethodIndex, 2)};
            this.structure = structure;
            this.origin = origin;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        try {
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public NMSStructure(Location origin, Object file) {
        if (file.getClass() != definedStructureClass) {
            throw new IllegalArgumentException("Object is not member of required class!");
        }
        try {
            Object tag = definedStructureMethodAccess.invoke(file, getStructureAsNBTMethodIndex, compoundNBTConstructorAccess.newInstance());
            Object dimTag = compoundNBTTagMethodAccess.invoke(tag, getNBTListMethodIndex, "size", 3);
            this.dimension = new int[]{(Integer)listNBTTagMethodAccess.invoke(dimTag, getNBTListItemMethodIndex, 0), (Integer)listNBTTagMethodAccess.invoke(dimTag, getNBTListItemMethodIndex, 1), (Integer)listNBTTagMethodAccess.invoke(dimTag, getNBTListItemMethodIndex, 2)};
            this.structure = file;
            this.origin = origin;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static Object getAsTag(InputStream file) {
        try {
            Object structure = definedStructureConstructorAccess.newInstance();
            definedStructureMethodAccess.invoke(structure, loadStructureMethodIndex, nbtStreamToolsAccess.invoke(null, loadNBTStreamFromInputStreamIndex, file));
            return structure;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void load() {
    }

    public Location getOrigin() {
        return this.origin;
    }

    public void setOrigin(Location origin) {
        this.origin = origin;
    }

    public int[] getDimensions() {
        return this.dimension;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        if (rotation % 90 != 0 || rotation > 360) {
            throw new IllegalArgumentException("Invalid rotation provided. Rotation must be multiple of 90.");
        }
        this.rotation = rotation;
    }

    public Location[] getBoundingLocations() {
        switch (this.rotation) {
            case 0: 
            case 360: {
                return new Location[]{this.origin, new Location(this.origin.getWorld(), this.origin.getX() + (double)this.getX(), this.origin.getY() + (double)this.getY(), this.origin.getZ() + (double)this.getZ())};
            }
            case 90: {
                return new Location[]{this.origin, new Location(this.origin.getWorld(), this.origin.getX() - (double)this.getZ(), this.origin.getY() + (double)this.getY(), this.origin.getZ() + (double)this.getX())};
            }
            case 180: {
                return new Location[]{this.origin, new Location(this.origin.getWorld(), this.origin.getX() - (double)this.getX(), this.origin.getY() + (double)this.getY(), this.origin.getZ() - (double)this.getZ())};
            }
            case 270: {
                return new Location[]{this.origin, new Location(this.origin.getWorld(), this.origin.getX() + (double)this.getZ(), this.origin.getY() + (double)this.getY(), this.origin.getZ() - (double)this.getX())};
            }
        }
        throw new IllegalArgumentException("Invalid rotation provided. Rotation must be multiple of 90.");
    }

    public int getX() {
        return this.dimension[0];
    }

    public int getY() {
        return this.dimension[1];
    }

    public int getZ() {
        return this.dimension[2];
    }

    public void paste() {
        try {
            Object rot;
            switch (this.rotation) {
                case 0: 
                case 360: {
                    rot = enumBlockRotationMethodAccess.invoke(null, enumBlockRotationValueOfIndex, "NONE");
                    break;
                }
                case 90: {
                    rot = enumBlockRotationMethodAccess.invoke(null, enumBlockRotationValueOfIndex, "CLOCKWISE_90");
                    break;
                }
                case 180: {
                    rot = enumBlockRotationMethodAccess.invoke(null, enumBlockRotationValueOfIndex, "CLOCKWISE_180");
                    break;
                }
                case 270: {
                    rot = enumBlockRotationMethodAccess.invoke(null, enumBlockRotationValueOfIndex, "COUNTERCLOCKWISE_90");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid rotation provided. Rotation must be multiple of 90.");
                }
            }
            Object world = craftWorldMethodAccess.invoke((Object)this.origin.getWorld(), getCraftWorldHandleIndex, new Object[0]);
            Object info = definedStructureInfoMethodAccess.invoke(definedStructureInfoConstructorAccess.newInstance(), setRotationMethodIndex, rot);
            Object pos = craftBlockMethodAccess.invoke((Object)this.origin.getBlock(), craftBlockGetPositionIndex, new Object[0]);
            info = definedStructureInfoMethodAccess.invoke(info, mysteryBooleanMethodIndex, false);
            info = definedStructureInfoMethodAccess.invoke(info, chunkCoordIntPairMethodIndex, new Object[]{null});
            info = definedStructureInfoMethodAccess.invoke(info, mysteryBooleancMethodIndex, false);
            info = definedStructureInfoMethodAccess.invoke(info, setRandomMethodIndex, new FastRandom());
            if (version.startsWith("v1_15")) {
                definedStructureMethodAccess.invoke(this.structure, pasteMethodIndex, world, pos, info);
            } else {
                definedStructureMethodAccess.invoke(this.structure, pasteMethodIndex, world, pos, info, new FastRandom());
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            long start = System.nanoTime();
            Bukkit.getLogger().info("[Gaea] Beginning reflections for net.minecraft.server." + version + ".");
            Class<?> craftWorldClass = Class.forName("org.bukkit.craftbukkit." + version + ".CraftWorld");
            Class<?> compoundNBTTagClass = Class.forName("net.minecraft.server." + version + ".NBTTagCompound");
            Class<?> definedStructureInfoClass = Class.forName("net.minecraft.server." + version + ".DefinedStructureInfo");
            Class<?> blockPositionClass = Class.forName("net.minecraft.server." + version + ".BlockPosition");
            Class<?> nbtStreamToolsClass = Class.forName("net.minecraft.server." + version + ".NBTCompressedStreamTools");
            definedStructureClass = Class.forName("net.minecraft.server." + version + ".DefinedStructure");
            Class<?> enumBlockRotationClass = Class.forName("net.minecraft.server." + version + ".EnumBlockRotation");
            Class<?> listNBTTagClass = Class.forName("net.minecraft.server." + version + ".NBTTagList");
            Class<?> chunkCoordIntPairClass = Class.forName("net.minecraft.server." + version + ".ChunkCoordIntPair");
            Class<?> craftBlockClass = Class.forName("org.bukkit.craftbukkit." + version + ".block.CraftBlock");
            Class<?> generatorAccessClass = version.startsWith("v1_15") || version.startsWith("v1_16_R1") ? Class.forName("net.minecraft.server." + version + ".GeneratorAccess") : Class.forName("net.minecraft.server." + version + ".WorldAccess");
            nbtStreamToolsAccess = MethodAccess.get(nbtStreamToolsClass);
            loadNBTStreamFromInputStreamIndex = nbtStreamToolsAccess.getIndex("a", InputStream.class);
            definedStructureConstructorAccess = ConstructorAccess.get(definedStructureClass);
            definedStructureMethodAccess = MethodAccess.get(definedStructureClass);
            loadStructureMethodIndex = definedStructureMethodAccess.getIndex("b", compoundNBTTagClass);
            getStructureAsNBTMethodIndex = definedStructureMethodAccess.getIndex("a", compoundNBTTagClass);
            pasteMethodIndex = version.startsWith("v1_15") ? definedStructureMethodAccess.getIndex("a", generatorAccessClass, blockPositionClass, definedStructureInfoClass) : definedStructureMethodAccess.getIndex("a", generatorAccessClass, blockPositionClass, definedStructureInfoClass, Random.class);
            compoundNBTConstructorAccess = ConstructorAccess.get(compoundNBTTagClass);
            compoundNBTTagMethodAccess = MethodAccess.get(compoundNBTTagClass);
            getNBTListMethodIndex = compoundNBTTagMethodAccess.getIndex("getList", String.class, Integer.TYPE);
            listNBTTagMethodAccess = MethodAccess.get(listNBTTagClass);
            getNBTListItemMethodIndex = listNBTTagMethodAccess.getIndex("e", Integer.TYPE);
            enumBlockRotationMethodAccess = MethodAccess.get(enumBlockRotationClass);
            enumBlockRotationValueOfIndex = enumBlockRotationMethodAccess.getIndex("valueOf", String.class);
            craftWorldMethodAccess = MethodAccess.get(craftWorldClass);
            getCraftWorldHandleIndex = craftWorldMethodAccess.getIndex("getHandle");
            definedStructureInfoMethodAccess = MethodAccess.get(definedStructureInfoClass);
            definedStructureInfoConstructorAccess = ConstructorAccess.get(definedStructureInfoClass);
            setRotationMethodIndex = definedStructureInfoMethodAccess.getIndex("a", enumBlockRotationClass);
            mysteryBooleanMethodIndex = definedStructureInfoMethodAccess.getIndex("a", Boolean.TYPE);
            chunkCoordIntPairMethodIndex = definedStructureInfoMethodAccess.getIndex("a", chunkCoordIntPairClass);
            mysteryBooleancMethodIndex = definedStructureInfoMethodAccess.getIndex("c", Boolean.TYPE);
            setRandomMethodIndex = definedStructureInfoMethodAccess.getIndex("a", Random.class);
            craftBlockMethodAccess = MethodAccess.get(craftBlockClass);
            craftBlockGetPositionIndex = craftBlockMethodAccess.getIndex("getPosition");
            Bukkit.getLogger().info("[Gaea] Finished reflections. Time elapsed: " + (double)(System.nanoTime() - start) / 1000000.0 + "ms");
        }
        catch (ClassNotFoundException e) {
            Bukkit.getLogger().severe("[Gaea] An error occurred whilst initializing Reflection. Please report this.");
            e.printStackTrace();
            Bukkit.getLogger().severe("[Gaea] Report the above error to Gaea!");
            Bukkit.getLogger().severe("[Gaea] This is most likely caused by running the plugin on an unsupported version.");
        }
    }
}

