/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.profiler;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.polydev.gaea.generation.GaeaChunkGenerator;
import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.profiler.DataType;
import org.polydev.gaea.profiler.Measurement;
import org.polydev.gaea.profiler.ProfileFuture;

public class WorldProfiler {
    private final BiMap<String, Measurement> measures = HashBiMap.create();
    private final World world;
    private boolean isProfiling;

    public WorldProfiler(World w) {
        if (!(w.getGenerator() instanceof GaeaChunkGenerator)) {
            throw new IllegalArgumentException("Attempted to instantiate profiler on non-Gaea managed world!");
        }
        this.addMeasurement(new Measurement(2500000L, DataType.PERIOD_MILLISECONDS), "TotalChunkGenTime").addMeasurement(new Measurement(2500000L, DataType.PERIOD_MILLISECONDS), "ChunkBaseGenTime").addMeasurement(new Measurement(2000000L, DataType.PERIOD_MILLISECONDS), "BiomeApplyTime").addMeasurement(new Measurement(2000000L, DataType.PERIOD_MILLISECONDS), "PopulationManagerTime");
        this.isProfiling = false;
        this.world = w;
        ((GaeaChunkGenerator)w.getGenerator()).attachProfiler(this);
    }

    public String getResultsFormatted() {
        if (!this.isProfiling) {
            return "Profiler is not currently running.";
        }
        StringBuilder result = new StringBuilder(ChatColor.GOLD + "Gaea World Profiler Results (Min / Avg / Max / Std Dev): \n");
        for (Map.Entry e : this.measures.entrySet()) {
            result.append(ChatColor.GOLD).append((String)e.getKey()).append(": ").append(((Measurement)e.getValue()).getDataHolder().getFormattedData(((Measurement)e.getValue()).getMin())).append(ChatColor.GOLD).append(" / ").append(((Measurement)e.getValue()).getDataHolder().getFormattedData(((Measurement)e.getValue()).average())).append(ChatColor.GOLD).append(" / ").append(((Measurement)e.getValue()).getDataHolder().getFormattedData(((Measurement)e.getValue()).getMax())).append(ChatColor.GOLD).append(" / ").append(ChatColor.GREEN).append((double)FastMath.round(((Measurement)e.getValue()).getStdDev() / 1000000.0 * 100.0) / 100.0).append("ms").append(ChatColor.GOLD).append(" (x").append(((Measurement)e.getValue()).size()).append(")\n");
        }
        return result.toString();
    }

    public void reset() {
        for (Map.Entry e : this.measures.entrySet()) {
            ((Measurement)e.getValue()).reset();
        }
    }

    public WorldProfiler addMeasurement(Measurement m, String name) {
        this.measures.put((Object)name, (Object)m);
        return this;
    }

    public void setMeasurement(String id, long value) {
        if (this.isProfiling) {
            ((Measurement)this.measures.get((Object)id)).record(value);
        }
    }

    public ProfileFuture measure(String id) {
        if (this.isProfiling) {
            return ((Measurement)this.measures.get((Object)id)).beginMeasurement();
        }
        return null;
    }

    public String getID(Measurement m) {
        return (String)this.measures.inverse().get((Object)m);
    }

    public boolean isProfiling() {
        return this.isProfiling;
    }

    public void setProfiling(boolean enabled) {
        this.isProfiling = enabled;
    }

    public World getWorld() {
        return this.world;
    }
}

