/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.profiler;

import java.math.BigInteger;
import java.util.List;
import org.bukkit.Bukkit;
import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.math.MathUtil;
import org.polydev.gaea.profiler.DataHolder;
import org.polydev.gaea.profiler.DataType;
import org.polydev.gaea.profiler.ProfileFuture;
import org.polydev.gaea.util.GlueList;

public class Measurement {
    private final List<Long> measurements;
    private final long desirable;
    private final DataType type;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;

    public Measurement(long desirable, DataType type) {
        this.desirable = desirable;
        this.type = type;
        this.measurements = new GlueList<Long>();
    }

    public void record(long value) {
        this.max = FastMath.max(value, this.max);
        this.min = FastMath.min(value, this.min);
        if (value / 1000000L > 5000L) {
            Bukkit.getLogger().warning("Measurement took " + this.type.getFormatted(value));
        }
        this.measurements.add(value);
    }

    public int size() {
        return this.measurements.size();
    }

    public ProfileFuture beginMeasurement() {
        ProfileFuture future = new ProfileFuture();
        long current = System.nanoTime();
        future.thenRun(() -> this.record(System.nanoTime() - current));
        return future;
    }

    public void reset() {
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.measurements.clear();
    }

    public DataHolder getDataHolder() {
        return new DataHolder(this.type, this.desirable, 0.25);
    }

    public long getMin() {
        if (this.min == Long.MAX_VALUE) {
            return 0L;
        }
        return this.min;
    }

    public long getMax() {
        if (this.max == Long.MIN_VALUE) {
            return 0L;
        }
        return this.max;
    }

    public long average() {
        BigInteger running = new BigInteger("0");
        GlueList<Long> mTemp = new GlueList<Long>(this.measurements);
        for (Long l : mTemp) {
            running = running.add(BigInteger.valueOf(l));
        }
        if (this.measurements.size() == 0) {
            return 0L;
        }
        return running.divide(BigInteger.valueOf(this.measurements.size())).longValue();
    }

    public double getStdDev() {
        GlueList<Long> mTemp = new GlueList<Long>(this.measurements);
        double[] vals = new double[mTemp.size()];
        for (int i = 0; i < mTemp.size(); ++i) {
            vals[i] = ((Long)mTemp.get(i)).longValue();
        }
        return MathUtil.standardDeviation(vals);
    }

    public int entries() {
        return this.measurements.size();
    }
}

