/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.profiler;

import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.profiler.Desire;

public enum DataType {
    PERIOD_MILLISECONDS(Desire.LOW, 1000000L, "ms"),
    PERIOD_NANOSECONDS(Desire.LOW, 1L, "ns");

    private final Desire desire;
    private final long divisor;
    private final String unit;

    private DataType(Desire d, long divisor, String unit) {
        this.desire = d;
        this.divisor = divisor;
        this.unit = unit;
    }

    public String getFormatted(long value) {
        return (double)FastMath.round((double)value / (double)this.divisor * 100.0) / 100.0 + this.unit;
    }

    public Desire getDesire() {
        return this.desire;
    }
}

