/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.profiler;

import net.md_5.bungee.api.ChatColor;
import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.profiler.DataType;

public class DataHolder {
    private final long desired;
    private final DataType type;
    private final double desiredRangePercent;

    public DataHolder(DataType type, long desired, double desiredRangePercent) {
        this.desired = desired;
        this.type = type;
        this.desiredRangePercent = desiredRangePercent;
    }

    public String getFormattedData(long data) {
        double range = this.desiredRangePercent * (double)this.desired;
        ChatColor color = ChatColor.YELLOW;
        if ((double)FastMath.abs(data - this.desired) > range) {
            color = data > this.desired ? this.type.getDesire().getHighColor() : this.type.getDesire().getLowColor();
        }
        return color + this.type.getFormatted(data) + ChatColor.RESET;
    }
}

