/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.population;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.polydev.gaea.Gaea;
import org.polydev.gaea.population.ChunkCoordinate;
import org.polydev.gaea.population.GaeaBlockPopulator;
import org.polydev.gaea.profiler.ProfileFuture;
import org.polydev.gaea.profiler.WorldProfiler;
import org.polydev.gaea.util.FastRandom;
import org.polydev.gaea.util.GlueList;
import org.polydev.gaea.util.SerializationUtil;

public class PopulationManager
extends BlockPopulator {
    private final List<GaeaBlockPopulator> attachedPopulators = new GlueList<GaeaBlockPopulator>();
    private final HashSet<ChunkCoordinate> needsPop = new HashSet();
    private final JavaPlugin main;
    private final Object popLock = new Object();
    private WorldProfiler profiler;

    public PopulationManager(JavaPlugin main) {
        this.main = main;
    }

    public void attach(GaeaBlockPopulator populator) {
        this.attachedPopulators.add(populator);
    }

    public void populate(@NotNull World world, @NotNull Random random, @NotNull Chunk chunk) {
        try (ProfileFuture ignored = this.measure();){
            this.needsPop.add(new ChunkCoordinate(chunk));
            int x = chunk.getX();
            int z = chunk.getZ();
            if (this.main.isEnabled()) {
                for (int xi = -1; xi <= 1; ++xi) {
                    for (int zi = -1; zi <= 1; ++zi) {
                        if (xi == 0 && zi == 0 || !world.isChunkGenerated(xi + x, zi + z)) continue;
                        this.checkNeighbors(xi + x, zi + z, world);
                    }
                }
            }
        }
    }

    private ProfileFuture measure() {
        if (this.profiler != null) {
            return this.profiler.measure("PopulationManagerTime");
        }
        return null;
    }

    public void attachProfiler(WorldProfiler p) {
        this.profiler = p;
    }

    public synchronized void saveBlocks(World w) throws IOException {
        File f = new File(Gaea.getGaeaFolder(w), "chunks.bin");
        f.createNewFile();
        SerializationUtil.toFile((HashSet)this.needsPop.clone(), f);
    }

    public synchronized void loadBlocks(World w) throws IOException, ClassNotFoundException {
        File f = new File(Gaea.getGaeaFolder(w), "chunks.bin");
        this.needsPop.addAll((HashSet)SerializationUtil.fromFile(f));
    }

    public synchronized void checkNeighbors(int x, int z, World w) {
        ChunkCoordinate c = new ChunkCoordinate(x, z, w.getUID());
        if (w.isChunkGenerated(x + 1, z) && w.isChunkGenerated(x - 1, z) && w.isChunkGenerated(x, z + 1) && w.isChunkGenerated(x, z - 1) && this.needsPop.contains(c)) {
            FastRandom random = new FastRandom(w.getSeed());
            long xRand = (((Random)random).nextLong() / 2L << 1) + 1L;
            long zRand = (((Random)random).nextLong() / 2L << 1) + 1L;
            ((Random)random).setSeed((long)x * xRand + (long)z * zRand ^ w.getSeed());
            Chunk currentChunk = w.getChunkAt(x, z);
            for (GaeaBlockPopulator r : this.attachedPopulators) {
                r.populate(w, random, currentChunk);
            }
            this.needsPop.remove(c);
        }
    }
}

