/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.math;

import java.util.Iterator;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.polydev.gaea.libs.jafama.FastMath;

public class Range
implements Iterable<Integer> {
    private int min;
    private int max;

    public Range(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("Minimum must not be grater than maximum!");
        }
        this.max = max;
        this.min = min;
    }

    public boolean isInRange(int test) {
        return test >= this.min && test < this.max;
    }

    public int getMax() {
        return this.max;
    }

    public Range setMax(int max) {
        this.max = max;
        return this;
    }

    public int getMin() {
        return this.min;
    }

    public Range setMin(int min) {
        this.min = min;
        return this;
    }

    public int getRange() {
        return this.max - this.min;
    }

    public Range multiply(int mult) {
        this.min *= mult;
        this.max *= mult;
        return this;
    }

    public Range reflect(int pt) {
        return new Range(2 * pt - this.getMax(), 2 * pt - this.getMin());
    }

    public int get(Random r) {
        return r.nextInt(this.max - this.min + 1) + this.min;
    }

    public Range intersects(Range other) {
        try {
            return new Range(FastMath.max(this.getMin(), other.getMin()), FastMath.min(this.getMax(), other.getMax()));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Range add(int add) {
        this.min += add;
        this.max += add;
        return this;
    }

    public Range sub(int sub) {
        this.min -= sub;
        this.max -= sub;
        return this;
    }

    public String toString() {
        return "Min: " + this.getMin() + ", Max:" + this.getMax();
    }

    public int hashCode() {
        return this.min * 31 + this.max;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return other.getMin() == this.getMin() && other.getMax() == this.getMax();
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new RangeIterator(this);
    }

    private static class RangeIterator
    implements Iterator<Integer> {
        private final Range m;
        private Integer current;

        public RangeIterator(Range m) {
            this.m = m;
            this.current = m.getMin();
        }

        @Override
        public boolean hasNext() {
            return this.current < this.m.getMax();
        }

        @Override
        public Integer next() {
            Integer n = this.current;
            Integer n2 = this.current = Integer.valueOf(this.current + 1);
            return this.current - 1;
        }
    }
}

