/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.math;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.polydev.gaea.biome.NormalizationUtil;
import org.polydev.gaea.math.FastNoiseLite;

public class ProbabilityCollection<E> {
    private final Set<Object> cont = new HashSet<Object>();
    private Object[] array = new Object[0];
    private int size;

    public ProbabilityCollection<E> add(E item, int probability) {
        if (!this.cont.contains(item)) {
            ++this.size;
        }
        this.cont.add(item);
        int oldLength = this.array.length;
        Object[] newArray = new Object[this.array.length + probability];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        this.array = newArray;
        for (int i = oldLength; i < this.array.length; ++i) {
            this.array[i] = item;
        }
        return this;
    }

    public E get() {
        if (this.array.length == 0) {
            return null;
        }
        return (E)this.array[ThreadLocalRandom.current().nextInt(this.array.length)];
    }

    public E get(Random r) {
        if (this.array.length == 0) {
            return null;
        }
        return (E)this.array[r.nextInt(this.array.length)];
    }

    public E get(FastNoiseLite n, double x, double z) {
        if (this.array.length == 0) {
            return null;
        }
        return (E)this.array[NormalizationUtil.normalize(n.getNoise(x, z), this.array.length, 1)];
    }

    public int getTotalProbability() {
        return this.array.length;
    }

    public int size() {
        return this.size;
    }
}

