/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.math;

import java.util.Random;
import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.util.FastRandom;

public class MathUtil {
    public static double standardDeviation(double[] numArray) {
        double sum = 0.0;
        double standardDeviation = 0.0;
        int length = numArray.length;
        for (double num : numArray) {
            sum += num;
        }
        double mean = sum / (double)length;
        for (double num : numArray) {
            standardDeviation += FastMath.pow(num - mean, 2.0);
        }
        return FastMath.sqrt(standardDeviation / (double)length);
    }

    public static long getCarverChunkSeed(int chunkX, int chunkZ, long seed) {
        FastRandom r = new FastRandom(seed);
        return (long)chunkX * ((Random)r).nextLong() ^ (long)chunkZ * ((Random)r).nextLong() ^ seed;
    }

    public static long hashToLong(String s) {
        if (s == null) {
            return 0L;
        }
        long hash = 0L;
        for (char c : s.toCharArray()) {
            hash = 31L * hash + (long)c;
        }
        return hash;
    }
}

