/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.math;

import org.polydev.gaea.libs.jafama.FastMath;

public class Interpolator {
    private final double v0;
    private final double v1;
    private final double v2;
    private final double v3;
    private final Type type;

    public Interpolator(double v0, double v1, double v2, double v3, Type type) {
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        this.type = type;
    }

    public static double lerp(double t, double v0, double v1, Type type) {
        switch (type) {
            case LINEAR: {
                return v0 + t * (v1 - v0);
            }
            case NEAREST_NEIGHBOR: {
                return FastMath.abs(v0 - t) > FastMath.abs(v1 - t) ? v1 : v0;
            }
        }
        throw new IllegalStateException();
    }

    public double bilerp(double s, double t) {
        double v01 = Interpolator.lerp(s, this.v0, this.v1, this.type);
        double v23 = Interpolator.lerp(s, this.v2, this.v3, this.type);
        double v = Interpolator.lerp(t, v01, v23, this.type);
        return v;
    }

    public static enum Type {
        LINEAR,
        NEAREST_NEIGHBOR;

    }
}

