/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.math;

import org.bukkit.World;
import org.polydev.gaea.biome.BiomeGrid;
import org.polydev.gaea.biome.Generator;
import org.polydev.gaea.generation.GenerationPhase;
import org.polydev.gaea.libs.jafama.FastMath;
import org.polydev.gaea.math.ChunkInterpolator;
import org.polydev.gaea.math.FastNoiseLite;
import org.polydev.gaea.math.Interpolator3;

public class ChunkInterpolator3
implements ChunkInterpolator {
    private final Interpolator3[][][] interpGrid = new Interpolator3[4][64][4];
    private final Generator[][] gens = new Generator[7][7];
    private final boolean[][] needsBiomeInterp = new boolean[5][5];
    private final double[][][] noiseStorage = new double[7][7][65];
    private final FastNoiseLite noise;
    private final int xOrigin;
    private final int zOrigin;
    private final World w;

    public ChunkInterpolator3(World w, int chunkX, int chunkZ, BiomeGrid grid, FastNoiseLite noise) {
        int z;
        int x;
        this.xOrigin = chunkX << 4;
        this.zOrigin = chunkZ << 4;
        this.noise = noise;
        this.w = w;
        for (x = -1; x < 6; ++x) {
            for (z = -1; z < 6; ++z) {
                this.gens[x + 1][z + 1] = grid.getBiome(this.xOrigin + (x << 2), this.zOrigin + (z << 2), GenerationPhase.BASE).getGenerator();
            }
        }
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                this.needsBiomeInterp[x][z] = this.compareGens(x + 1, z + 1);
            }
        }
        this.storeNoise();
        for (x = 0; x < 4; x = (int)((byte)(x + 1))) {
            for (z = 0; z < 4; z = (int)((byte)(z + 1))) {
                for (int y = 0; y < 64; ++y) {
                    this.interpGrid[x][y][z] = new Interpolator3(this.biomeAvg(x, y, z), this.biomeAvg(x + 1, y, z), this.biomeAvg(x, y + 1, z), this.biomeAvg(x + 1, y + 1, z), this.biomeAvg(x, y, z + 1), this.biomeAvg(x + 1, y, z + 1), this.biomeAvg(x, y + 1, z + 1), this.biomeAvg(x + 1, y + 1, z + 1), this.gens[x + 1][z + 1].getInterpolationType());
                }
            }
        }
    }

    private boolean compareGens(int x, int z) {
        Generator comp = this.gens[x][z];
        if (!comp.equals(this.gens[x + 1][z])) {
            return true;
        }
        if (!comp.equals(this.gens[x][z + 1])) {
            return true;
        }
        if (!comp.equals(this.gens[x - 1][z])) {
            return true;
        }
        if (!comp.equals(this.gens[x][z - 1])) {
            return true;
        }
        if (!comp.equals(this.gens[x + 1][z + 1])) {
            return true;
        }
        if (!comp.equals(this.gens[x - 1][z - 1])) {
            return true;
        }
        if (!comp.equals(this.gens[x + 1][z - 1])) {
            return true;
        }
        return !comp.equals(this.gens[x - 1][z + 1]);
    }

    private void storeNoise() {
        for (int x = -1; x < 6; x = (int)((byte)(x + 1))) {
            for (int z = -1; z < 6; z = (int)((byte)(z + 1))) {
                for (int y = 0; y < 64; ++y) {
                    this.noiseStorage[x + 1][z + 1][y] = this.gens[x + 1][z + 1].getNoise(this.noise, this.w, (x << 2) + this.xOrigin, y << 2, (z << 2) + this.zOrigin);
                }
            }
        }
    }

    private double biomeAvg(int x, int y, int z) {
        if (this.needsBiomeInterp[x][z]) {
            return (this.noiseStorage[x + 2][z + 1][y] + this.noiseStorage[x][z + 1][y] + this.noiseStorage[x + 1][z + 2][y] + this.noiseStorage[x + 1][z][y] + this.noiseStorage[x][z][y] + this.noiseStorage[x + 2][z + 2][y] + this.noiseStorage[x + 2][z][y] + this.noiseStorage[x][z + 2][y] + this.noiseStorage[x + 1][z + 1][y]) / 9.0;
        }
        if (this.gens[x + 1][z + 1].useMinimalInterpolation()) {
            return this.noiseStorage[x + 1][z + 1][y];
        }
        return (this.noiseStorage[x + 2][z + 1][y] + this.noiseStorage[x][z + 1][y] + this.noiseStorage[x + 1][z + 2][y] + this.noiseStorage[x + 1][z][y] + this.noiseStorage[x + 1][z + 1][y]) / 5.0;
    }

    @Override
    public double getNoise(double x, double z) {
        return this.getNoise(x, 0.0, z);
    }

    @Override
    public double getNoise(double x, double y, double z) {
        return this.interpGrid[ChunkInterpolator3.reRange((int)x / 4, 3)][ChunkInterpolator3.reRange((int)y / 4, 63)][ChunkInterpolator3.reRange((int)z / 4, 3)].trilerp(x % 4.0 / 4.0, y % 4.0 / 4.0, z % 4.0 / 4.0);
    }

    private static int reRange(int value, int high) {
        return FastMath.max(FastMath.min(value, high), 0);
    }
}

