/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.math;

import org.bukkit.World;
import org.polydev.gaea.biome.BiomeGrid;
import org.polydev.gaea.biome.Generator;
import org.polydev.gaea.generation.GenerationPhase;
import org.polydev.gaea.math.ChunkInterpolator;
import org.polydev.gaea.math.FastNoiseLite;
import org.polydev.gaea.math.Interpolator;

public class ChunkInterpolator2
implements ChunkInterpolator {
    private final Interpolator[][] interpGrid = new Interpolator[4][4];
    private final int xOrigin;
    private final int zOrigin;
    private final FastNoiseLite noise;
    private final World w;

    public ChunkInterpolator2(World w, int chunkX, int chunkZ, BiomeGrid grid, FastNoiseLite noise) {
        int z;
        int x;
        this.xOrigin = chunkX << 4;
        this.zOrigin = chunkZ << 4;
        this.noise = noise;
        this.w = w;
        Generator[][] gridTemp = new Generator[8][8];
        for (x = -2; x < 6; ++x) {
            for (z = -2; z < 6; ++z) {
                gridTemp[x + 2][z + 2] = grid.getBiome(this.xOrigin + (x << 2), this.zOrigin + (z << 2), GenerationPhase.BASE).getGenerator();
            }
        }
        for (x = 0; x < 4; x = (int)((byte)(x + 1))) {
            for (z = 0; z < 4; z = (int)((byte)(z + 1))) {
                this.interpGrid[x][z] = new Interpolator(this.biomeAvg(x, z, gridTemp), this.biomeAvg(x + 1, z, gridTemp), this.biomeAvg(x, z + 1, gridTemp), this.biomeAvg(x + 1, z + 1, gridTemp), gridTemp[x + 1][z + 1].getInterpolationType());
            }
        }
    }

    private double biomeAvg(int x, int z, Generator[][] g) {
        return (g[x + 3][z + 2].getNoise(this.noise, this.w, (x << 2) + this.xOrigin, (z << 2) + this.zOrigin) + g[x + 1][z + 2].getNoise(this.noise, this.w, (x << 2) + this.xOrigin, (z << 2) + this.zOrigin) + g[x + 2][z + 3].getNoise(this.noise, this.w, (x << 2) + this.xOrigin, (z << 2) + this.zOrigin) + g[x + 2][z + 1].getNoise(this.noise, this.w, (x << 2) + this.xOrigin, (z << 2) + this.zOrigin)) / 4.0;
    }

    @Override
    public double getNoise(double x, double z) {
        return this.interpGrid[(int)x / 4][(int)z / 4].bilerp(x % 4.0 / 4.0, z % 4.0 / 4.0);
    }

    @Override
    public double getNoise(double x, double y, double z) {
        return this.getNoise(x, z);
    }
}

