/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.taskchain;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.polydev.gaea.libs.taskchain.AsyncQueue;
import org.polydev.gaea.libs.taskchain.GameInterface;
import org.polydev.gaea.libs.taskchain.SharedTaskChain;
import org.polydev.gaea.libs.taskchain.TaskChain;
import org.polydev.gaea.libs.taskchain.TaskChainTasks;

public class TaskChainFactory {
    private final GameInterface impl;
    private final AsyncQueue asyncQueue;
    private final Map<String, Queue<SharedTaskChain>> sharedChains = new HashMap<String, Queue<SharedTaskChain>>();
    private volatile BiConsumer<Exception, TaskChainTasks.Task<?, ?>> defaultErrorHandler;
    volatile boolean shutdown = false;

    public TaskChainFactory(GameInterface impl) {
        this.impl = impl;
        this.asyncQueue = impl.getAsyncQueue();
        impl.registerShutdownHandler(this);
    }

    GameInterface getImplementation() {
        return this.impl;
    }

    public Map<String, Queue<SharedTaskChain>> getSharedChains() {
        return this.sharedChains;
    }

    public <T> TaskChain<T> newChain() {
        return new TaskChain(this);
    }

    public synchronized <T> TaskChain<T> newSharedChain(String name) {
        return new SharedTaskChain(name, this);
    }

    public BiConsumer<Exception, TaskChainTasks.Task<?, ?>> getDefaultErrorHandler() {
        return this.defaultErrorHandler;
    }

    public void setDefaultErrorHandler(BiConsumer<Exception, TaskChainTasks.Task<?, ?>> errorHandler) {
        this.defaultErrorHandler = errorHandler;
    }

    public void shutdown(int duration, TimeUnit units) {
        this.shutdown = true;
        this.asyncQueue.shutdown(duration, units);
    }
}

