/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.taskchain;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.polydev.gaea.libs.taskchain.AsyncQueue;
import org.polydev.gaea.libs.taskchain.TaskChain;
import org.polydev.gaea.libs.taskchain.TaskChainFactory;
import org.polydev.gaea.libs.taskchain.TaskChainUtil;

public class TaskChainExample {
    public static void example(TaskChainFactory factory) {
        TaskChainUtil.log("Starting example");
        AsyncQueue asyncQueue = factory.getImplementation().getAsyncQueue();
        CompletableFuture f1 = new CompletableFuture();
        CompletableFuture f2 = new CompletableFuture();
        CompletableFuture f3 = new CompletableFuture();
        TaskChain chain = factory.newSharedChain("TEST");
        chain.delay(60).sync(() -> {
            chain.setTaskData("test", 1);
            TaskChainUtil.log("==> 1st test - completing f3 with 8");
            f3.complete(8);
        }).delay(20).async(() -> {
            Object test = chain.getTaskData("test");
            TaskChainUtil.log("==> 2nd test: " + test + " = should be 1");
        }).sync(TaskChain::abort).execute(finished -> TaskChainUtil.log("first test finished: " + finished));
        CompletableFuture<String> falready = new CompletableFuture<String>();
        falready.complete("FOO!");
        factory.newChain().current(() -> TaskChainUtil.log("Starting Future task")).futures(f1, f2, f3).syncFutures(lists -> {
            Integer sum = lists.stream().collect(Collectors.summingInt(i -> i));
            TaskChainUtil.log("Future complete! got " + lists.size() + " answers that sum to (expect 16): " + sum);
            ArrayList ret = new ArrayList();
            CompletableFuture other = new CompletableFuture();
            asyncQueue.postAsync(() -> other.complete("Result: " + sum));
            ret.add(falready);
            ret.add(other);
            return ret;
        }).currentLast(results -> {
            TaskChainUtil.log("Results from last future task");
            for (String result : results) {
                TaskChainUtil.log(result);
            }
        }).execute();
        asyncQueue.postAsync(() -> {
            TaskChain chain2 = factory.newSharedChain("TEST");
            chain2.sync(() -> {
                Object test = chain2.getTaskData("test");
                TaskChainUtil.log("==> 3rd test: " + test + " = should be null");
            }).delay(20).current(() -> {
                TaskChainUtil.log("test 2nd chain 20 ticks later - completing f2 with 3");
                f2.complete(3);
            }).execute(finished -> TaskChainUtil.log("second test finished: " + finished));
            factory.newSharedChain("TEST").async(() -> TaskChainUtil.log("==> 4th test - should print")).returnData("notthere").abortIfNull().syncLast(val -> TaskChainUtil.log("Shouldn't execute due to null abort")).execute(() -> TaskChainUtil.log("finished runnable based test"));
        });
        factory.newSharedChain("TEST2").delay(60).sync(() -> TaskChainUtil.log("this should run at same time as 1st test")).delay(20).async(() -> TaskChainUtil.log("this should run at same time as 2nd test")).execute(finished -> TaskChainUtil.log("TEST2 finished: " + finished));
        factory.newChain().asyncFirst(() -> TaskChain.multi(42, "Foo", Float.valueOf(4.32f))).asyncLast(d -> {
            throw new RuntimeException("Got " + d.var1 + ", " + (String)d.var2 + ", " + d.var3);
        }).execute(finished -> TaskChainUtil.log("Finished error chain: " + finished), (e, task) -> TaskChainUtil.logError("Got Exception on task " + task.getClass().getName() + ":" + e.getMessage()));
        factory.newChain().sync(() -> TaskChainUtil.log("THE FIRST!")).delay(200).async(() -> TaskChainUtil.log("This ran async - with no input or return")).asyncFirstCallback(next -> {
            TaskChainUtil.log("this also ran async, but will call next task in 3 seconds.");
            factory.getImplementation().scheduleTask(60, () -> {
                TaskChainUtil.log("completing f1 with 5");
                f1.complete(5);
                next.accept(3);
            });
        }).sync(input -> {
            TaskChainUtil.log("should of got 3: " + input);
            return 5 + input;
        }).asyncFuture(foo -> {
            CompletableFuture future = new CompletableFuture();
            asyncQueue.postAsync(() -> {
                TaskChainUtil.log("Sleeping 1 before completing future");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                future.complete(foo + 10);
            });
            TaskChainUtil.log("Returning Future");
            return future;
        }).storeAsData("Test1").syncLast(input2 -> TaskChainUtil.log("should be 18: " + input2)).delay(20).sync(() -> TaskChainUtil.log("Generic 1s later")).asyncFirst(() -> 3).delay(100).asyncLast(input1 -> TaskChainUtil.log("async last value 5s later should be 3: " + input1)).returnData("Test1").asyncLast(val -> TaskChainUtil.log("Should of got 18 back from data: " + val)).returnData("Test1").abortIf(18).sync(() -> TaskChainUtil.log("Shouldn't be called")).execute(finished -> TaskChainUtil.log("final test chain finished: " + finished));
    }
}

