/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.taskchain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.polydev.gaea.libs.taskchain.AbortChainException;
import org.polydev.gaea.libs.taskchain.GameInterface;
import org.polydev.gaea.libs.taskchain.TaskChainAbortAction;
import org.polydev.gaea.libs.taskchain.TaskChainDataWrappers;
import org.polydev.gaea.libs.taskchain.TaskChainFactory;
import org.polydev.gaea.libs.taskchain.TaskChainTasks;
import org.polydev.gaea.libs.taskchain.TaskChainUtil;

public class TaskChain<T> {
    private static final ThreadLocal<TaskChain<?>> currentChain = new ThreadLocal();
    private final GameInterface impl;
    private final TaskChainFactory factory;
    private final Map<String, Object> taskMap = new HashMap<String, Object>(0);
    private final ConcurrentLinkedQueue<TaskHolder<?, ?>> chainQueue = new ConcurrentLinkedQueue();
    private int currentActionIndex = 0;
    private int actionIndex = 0;
    private boolean executed = false;
    private boolean async = false;
    private boolean done = false;
    private Object previous;
    private TaskHolder<?, ?> currentHolder;
    private Consumer<Boolean> doneCallback;
    private BiConsumer<Exception, TaskChainTasks.Task<?, ?>> errorHandler;

    TaskChain(TaskChainFactory factory) {
        this.factory = factory;
        this.impl = factory.getImplementation();
    }

    public int getCurrentActionIndex() {
        return this.currentActionIndex;
    }

    public void setDoneCallback(Consumer<Boolean> doneCallback) {
        this.doneCallback = doneCallback;
    }

    public BiConsumer<Exception, TaskChainTasks.Task<?, ?>> getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(BiConsumer<Exception, TaskChainTasks.Task<?, ?>> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public static <D1, D2> TaskChainDataWrappers.Data2<D1, D2> multi(D1 var1, D2 var2) {
        return new TaskChainDataWrappers.Data2<D1, D2>(var1, var2);
    }

    public static <D1, D2, D3> TaskChainDataWrappers.Data3<D1, D2, D3> multi(D1 var1, D2 var2, D3 var3) {
        return new TaskChainDataWrappers.Data3<D1, D2, D3>(var1, var2, var3);
    }

    public static <D1, D2, D3, D4> TaskChainDataWrappers.Data4<D1, D2, D3, D4> multi(D1 var1, D2 var2, D3 var3, D4 var4) {
        return new TaskChainDataWrappers.Data4<D1, D2, D3, D4>(var1, var2, var3, var4);
    }

    public static <D1, D2, D3, D4, D5> TaskChainDataWrappers.Data5<D1, D2, D3, D4, D5> multi(D1 var1, D2 var2, D3 var3, D4 var4, D5 var5) {
        return new TaskChainDataWrappers.Data5<D1, D2, D3, D4, D5>(var1, var2, var3, var4, var5);
    }

    public static <D1, D2, D3, D4, D5, D6> TaskChainDataWrappers.Data6<D1, D2, D3, D4, D5, D6> multi(D1 var1, D2 var2, D3 var3, D4 var4, D5 var5, D6 var6) {
        return new TaskChainDataWrappers.Data6<D1, D2, D3, D4, D5, D6>(var1, var2, var3, var4, var5, var6);
    }

    public static void abort() {
        TaskChainUtil.sneakyThrows(new AbortChainException());
    }

    public static TaskChain<?> getCurrentChain() {
        return currentChain.get();
    }

    public TaskChain<T> configure(Consumer<TaskChain<T>> configure) {
        configure.accept(this);
        return this;
    }

    public boolean hasTaskData(String key) {
        return this.taskMap.containsKey(key);
    }

    public <R> R getTaskData(String key) {
        return (R)this.taskMap.get(key);
    }

    public <R> R setTaskData(String key, Object val) {
        return (R)this.taskMap.put(key, val);
    }

    public <R> R removeTaskData(String key) {
        return (R)this.taskMap.remove(key);
    }

    public TaskChain<T> storeAsData(String key) {
        return this.current((T val) -> {
            this.setTaskData(key, val);
            return val;
        });
    }

    public <R> TaskChain<R> returnData(String key) {
        return this.currentFirst(() -> this.getTaskData(key));
    }

    public TaskChain<TaskChain<?>> returnChain() {
        return this.currentFirst(() -> this);
    }

    public TaskChain<T> delay(int gameUnits) {
        return this.currentCallback((T input, Consumer<R> next) -> this.impl.scheduleTask(gameUnits, () -> next.accept(input)));
    }

    public TaskChain<T> delay(int duration, TimeUnit unit) {
        return this.currentCallback((T input, Consumer<R> next) -> this.impl.scheduleTask(duration, unit, () -> next.accept(input)));
    }

    public TaskChain<?> abortChain() {
        if (this.executed) {
            TaskChain.abort();
            return this;
        }
        return this.current(TaskChain::abort);
    }

    public TaskChain<T> abortIfNull() {
        return this.abortIfNull(null, null, null, null);
    }

    public TaskChain<T> abortIfNull(TaskChainAbortAction<?, ?, ?> action) {
        return this.abortIf(Predicate.isEqual(null), (TaskChainAbortAction)action, (Object)null, (Object)null, (Object)null);
    }

    public <A1> TaskChain<T> abortIfNull(TaskChainAbortAction<A1, ?, ?> action, A1 arg1) {
        return this.abortIf(Predicate.isEqual(null), (TaskChainAbortAction)action, arg1, (Object)null, (Object)null);
    }

    public <A1, A2> TaskChain<T> abortIfNull(TaskChainAbortAction<A1, A2, ?> action, A1 arg1, A2 arg2) {
        return this.abortIf(Predicate.isEqual(null), (TaskChainAbortAction)action, arg1, arg2, (Object)null);
    }

    public <A1, A2, A3> TaskChain<T> abortIfNull(TaskChainAbortAction<A1, A2, A3> action, A1 arg1, A2 arg2, A3 arg3) {
        return this.abortIf(Predicate.isEqual(null), action, arg1, arg2, arg3);
    }

    public TaskChain<T> abortIf(T ifObj) {
        return this.abortIf(ifObj, null, null, null, null);
    }

    public TaskChain<T> abortIf(T ifObj, TaskChainAbortAction<?, ?, ?> action) {
        return this.abortIf(ifObj, action, null, null, null);
    }

    public <A1> TaskChain<T> abortIf(T ifObj, TaskChainAbortAction<A1, ?, ?> action, A1 arg1) {
        return this.abortIf(ifObj, action, arg1, null, null);
    }

    public <A1, A2> TaskChain<T> abortIf(T ifObj, TaskChainAbortAction<A1, A2, ?> action, A1 arg1, A2 arg2) {
        return this.abortIf(ifObj, action, arg1, arg2, null);
    }

    public <A1, A2, A3> TaskChain<T> abortIf(T ifObj, TaskChainAbortAction<A1, A2, A3> action, A1 arg1, A2 arg2, A3 arg3) {
        return this.abortIf(Predicate.isEqual(ifObj), action, arg1, arg2, arg3);
    }

    public TaskChain<T> abortIf(Predicate<T> predicate) {
        return this.abortIf(predicate, (TaskChainAbortAction)null, (Object)null, (Object)null, (Object)null);
    }

    public TaskChain<T> abortIf(Predicate<T> predicate, TaskChainAbortAction<?, ?, ?> action) {
        return this.abortIf(predicate, (TaskChainAbortAction)action, (Object)null, (Object)null, (Object)null);
    }

    public <A1> TaskChain<T> abortIf(Predicate<T> predicate, TaskChainAbortAction<A1, ?, ?> action, A1 arg1) {
        return this.abortIf(predicate, (TaskChainAbortAction)action, arg1, (Object)null, (Object)null);
    }

    public <A1, A2> TaskChain<T> abortIf(Predicate<T> predicate, TaskChainAbortAction<A1, A2, ?> action, A1 arg1, A2 arg2) {
        return this.abortIf(predicate, (TaskChainAbortAction)action, arg1, arg2, (Object)null);
    }

    public <A1, A2, A3> TaskChain<T> abortIf(Predicate<T> predicate, TaskChainAbortAction<A1, A2, A3> action, A1 arg1, A2 arg2, A3 arg3) {
        return this.current((T obj) -> {
            if (predicate.test(obj)) {
                this.handleAbortAction(action, arg1, arg2, arg3);
                return null;
            }
            return obj;
        });
    }

    public TaskChain<T> abortIfNot(T ifNotObj) {
        return this.abortIfNot(ifNotObj, null, null, null, null);
    }

    public TaskChain<T> abortIfNot(T ifNotObj, TaskChainAbortAction<?, ?, ?> action) {
        return this.abortIfNot(ifNotObj, action, null, null, null);
    }

    public <A1> TaskChain<T> abortIfNot(T ifNotObj, TaskChainAbortAction<A1, ?, ?> action, A1 arg1) {
        return this.abortIfNot(ifNotObj, action, arg1, null, null);
    }

    public <A1, A2> TaskChain<T> abortIfNot(T ifNotObj, TaskChainAbortAction<A1, A2, ?> action, A1 arg1, A2 arg2) {
        return this.abortIfNot(ifNotObj, action, arg1, arg2, null);
    }

    public <A1, A2, A3> TaskChain<T> abortIfNot(T ifNotObj, TaskChainAbortAction<A1, A2, A3> action, A1 arg1, A2 arg2, A3 arg3) {
        return this.abortIfNot(Predicate.isEqual(ifNotObj), action, arg1, arg2, arg3);
    }

    public TaskChain<T> abortIfNot(Predicate<T> ifNotPredicate) {
        return this.abortIfNot(ifNotPredicate, (TaskChainAbortAction)null, (Object)null, (Object)null, (Object)null);
    }

    public TaskChain<T> abortIfNot(Predicate<T> ifNotPredicate, TaskChainAbortAction<?, ?, ?> action) {
        return this.abortIfNot(ifNotPredicate, (TaskChainAbortAction)action, (Object)null, (Object)null, (Object)null);
    }

    public <A1> TaskChain<T> abortIfNot(Predicate<T> ifNotPredicate, TaskChainAbortAction<A1, ?, ?> action, A1 arg1) {
        return this.abortIfNot(ifNotPredicate, (TaskChainAbortAction)action, arg1, (Object)null, (Object)null);
    }

    public <A1, A2> TaskChain<T> abortIfNot(Predicate<T> ifNotPredicate, TaskChainAbortAction<A1, A2, ?> action, A1 arg1, A2 arg2) {
        return this.abortIfNot(ifNotPredicate, (TaskChainAbortAction)action, arg1, arg2, (Object)null);
    }

    public <A1, A2, A3> TaskChain<T> abortIfNot(Predicate<T> ifNotPredicate, TaskChainAbortAction<A1, A2, A3> action, A1 arg1, A2 arg2, A3 arg3) {
        return this.abortIf(ifNotPredicate.negate(), action, arg1, arg2, arg3);
    }

    public <R> TaskChain<R> syncFirstCallback(TaskChainTasks.AsyncExecutingFirstTask<R> task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public <R> TaskChain<R> asyncFirstCallback(TaskChainTasks.AsyncExecutingFirstTask<R> task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public <R> TaskChain<R> currentFirstCallback(TaskChainTasks.AsyncExecutingFirstTask<R> task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public <R> TaskChain<R> syncCallback(TaskChainTasks.AsyncExecutingTask<R, T> task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public TaskChain<?> syncCallback(TaskChainTasks.AsyncExecutingGenericTask task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public <R> TaskChain<R> asyncCallback(TaskChainTasks.AsyncExecutingTask<R, T> task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public TaskChain<?> asyncCallback(TaskChainTasks.AsyncExecutingGenericTask task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public <R> TaskChain<R> currentCallback(TaskChainTasks.AsyncExecutingTask<R, T> task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public TaskChain<?> currentCallback(TaskChainTasks.AsyncExecutingGenericTask task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public <R> TaskChain<R> future(CompletableFuture<R> future) {
        return this.currentFuture((T input) -> future);
    }

    @SafeVarargs
    public final <R> TaskChain<List<R>> futures(CompletableFuture<R> ... futures) {
        ArrayList<CompletableFuture<R>> futureList = new ArrayList<CompletableFuture<R>>(futures.length);
        Collections.addAll(futureList, futures);
        return this.futures(futureList);
    }

    public <R> TaskChain<List<R>> futures(List<CompletableFuture<R>> futures) {
        return this.currentFuture((T input) -> this.getFuture(futures));
    }

    public <R> TaskChain<List<R>> syncFutures(TaskChainTasks.Task<List<CompletableFuture<R>>, T> task) {
        return this.syncFuture((T input) -> this.getFuture((List)task.run(input)));
    }

    public <R> TaskChain<List<R>> asyncFutures(TaskChainTasks.Task<List<CompletableFuture<R>>, T> task) {
        return this.asyncFuture((T input) -> this.getFuture((List)task.run(input)));
    }

    public <R> TaskChain<List<R>> currentFutures(TaskChainTasks.Task<List<CompletableFuture<R>>, T> task) {
        return this.currentFuture((T input) -> this.getFuture((List)task.run(input)));
    }

    public <R> TaskChain<List<R>> syncFirstFutures(TaskChainTasks.FirstTask<List<CompletableFuture<R>>> task) {
        return this.syncFuture((T input) -> this.getFuture((List)task.run()));
    }

    public <R> TaskChain<List<R>> asyncFirstFutures(TaskChainTasks.FirstTask<List<CompletableFuture<R>>> task) {
        return this.asyncFuture((T input) -> this.getFuture((List)task.run()));
    }

    public <R> TaskChain<List<R>> currentFirstFutures(TaskChainTasks.FirstTask<List<CompletableFuture<R>>> task) {
        return this.currentFuture((T input) -> this.getFuture((List)task.run()));
    }

    public <R> TaskChain<R> syncFirstFuture(TaskChainTasks.FutureFirstTask<R> task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public <R> TaskChain<R> asyncFirstFuture(TaskChainTasks.FutureFirstTask<R> task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public <R> TaskChain<R> currentFirstFuture(TaskChainTasks.FutureFirstTask<R> task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public <R> TaskChain<R> syncFuture(TaskChainTasks.FutureTask<R, T> task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public TaskChain<?> syncFuture(TaskChainTasks.FutureGenericTask task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public <R> TaskChain<R> asyncFuture(TaskChainTasks.FutureTask<R, T> task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public TaskChain<?> asyncFuture(TaskChainTasks.FutureGenericTask task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public <R> TaskChain<R> currentFuture(TaskChainTasks.FutureTask<R, T> task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public TaskChain<?> currentFuture(TaskChainTasks.FutureGenericTask task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public <R> TaskChain<R> syncFirst(TaskChainTasks.FirstTask<R> task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public <R> TaskChain<R> asyncFirst(TaskChainTasks.FirstTask<R> task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public <R> TaskChain<R> currentFirst(TaskChainTasks.FirstTask<R> task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public <R> TaskChain<R> sync(TaskChainTasks.Task<R, T> task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public TaskChain<?> sync(TaskChainTasks.GenericTask task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public <R> TaskChain<R> async(TaskChainTasks.Task<R, T> task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public TaskChain<?> async(TaskChainTasks.GenericTask task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public <R> TaskChain<R> current(TaskChainTasks.Task<R, T> task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public TaskChain<?> current(TaskChainTasks.GenericTask task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public TaskChain<?> syncLast(TaskChainTasks.LastTask<T> task) {
        return this.add0(new TaskHolder(this, false, task));
    }

    public TaskChain<?> asyncLast(TaskChainTasks.LastTask<T> task) {
        return this.add0(new TaskHolder(this, true, task));
    }

    public TaskChain<?> currentLast(TaskChainTasks.LastTask<T> task) {
        return this.add0(new TaskHolder(this, null, task));
    }

    public void execute() {
        this.execute((Consumer<Boolean>)null, null);
    }

    public void execute(Runnable done) {
        this.execute((Boolean finished) -> done.run(), null);
    }

    public void execute(Runnable done, BiConsumer<Exception, TaskChainTasks.Task<?, ?>> errorHandler) {
        this.execute((Boolean finished) -> done.run(), errorHandler);
    }

    public void execute(Consumer<Boolean> done) {
        this.execute(done, null);
    }

    public void execute(BiConsumer<Exception, TaskChainTasks.Task<?, ?>> errorHandler) {
        this.execute((Consumer<Boolean>)null, errorHandler);
    }

    public void execute(Consumer<Boolean> done, BiConsumer<Exception, TaskChainTasks.Task<?, ?>> errorHandler) {
        if (errorHandler == null) {
            errorHandler = this.factory.getDefaultErrorHandler();
        }
        this.doneCallback = done;
        this.errorHandler = errorHandler;
        this.execute0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A1, A2, A3> void handleAbortAction(TaskChainAbortAction<A1, A2, A3> action, A1 arg1, A2 arg2, A3 arg3) {
        if (action != null) {
            TaskChain<?> prev = currentChain.get();
            try {
                currentChain.set(this);
                action.onAbort(this, arg1, arg2, arg3);
            }
            catch (Exception e) {
                TaskChainUtil.logError("TaskChain Exception in Abort Action handler: " + action.getClass().getName());
                TaskChainUtil.logError("Current Action Index was: " + this.currentActionIndex);
                e.printStackTrace();
            }
            finally {
                currentChain.set(prev);
            }
        }
        TaskChain.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute0() {
        TaskChain taskChain = this;
        synchronized (taskChain) {
            if (this.executed) {
                throw new RuntimeException("Already executed");
            }
            this.executed = true;
        }
        this.async = !this.impl.isMainThread();
        this.nextTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done(boolean finished) {
        this.done = true;
        if (this.doneCallback != null) {
            TaskChain<?> prev = currentChain.get();
            try {
                currentChain.set(this);
                this.doneCallback.accept(finished);
            }
            catch (Exception e) {
                this.handleError(e, null);
            }
            finally {
                currentChain.set(prev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskChain add0(TaskHolder<?, ?> task) {
        TaskChain taskChain = this;
        synchronized (taskChain) {
            if (this.executed) {
                throw new RuntimeException("TaskChain is executing");
            }
        }
        this.chainQueue.add(task);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextTask() {
        TaskChain taskChain = this;
        synchronized (taskChain) {
            this.currentHolder = this.chainQueue.poll();
            if (this.currentHolder == null) {
                this.done = true;
            }
        }
        if (this.currentHolder == null) {
            this.previous = null;
            this.done(true);
            return;
        }
        Boolean isNextAsync = this.currentHolder.async;
        if (isNextAsync == null || this.factory.shutdown) {
            ((TaskHolder)this.currentHolder).run();
        } else if (isNextAsync.booleanValue()) {
            if (this.async) {
                ((TaskHolder)this.currentHolder).run();
            } else {
                this.impl.postAsync(() -> {
                    this.async = true;
                    ((TaskHolder)this.currentHolder).run();
                });
            }
        } else if (this.async) {
            this.impl.postToMain(() -> {
                this.async = false;
                ((TaskHolder)this.currentHolder).run();
            });
        } else {
            ((TaskHolder)this.currentHolder).run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(Throwable throwable, TaskChainTasks.Task<?, ?> task) {
        Exception e;
        Exception exception = e = throwable instanceof Exception ? (Exception)throwable : new Exception(throwable);
        if (this.errorHandler != null) {
            TaskChain<?> prev = currentChain.get();
            try {
                currentChain.set(this);
                this.errorHandler.accept(e, task);
            }
            catch (Exception e2) {
                TaskChainUtil.logError("TaskChain Exception in the error handler!" + e2.getMessage());
                TaskChainUtil.logError("Current Action Index was: " + this.currentActionIndex);
                e.printStackTrace();
            }
            finally {
                currentChain.set(prev);
            }
        } else {
            TaskChainUtil.logError("TaskChain Exception on " + (task != null ? task.getClass().getName() : "Done Hander") + ": " + e.getMessage());
            TaskChainUtil.logError("Current Action Index was: " + this.currentActionIndex);
            e.printStackTrace();
        }
    }

    private void abortExecutingChain() {
        this.previous = null;
        this.chainQueue.clear();
        this.done(false);
    }

    private <R> CompletableFuture<List<R>> getFuture(List<CompletableFuture<R>> futures) {
        CompletableFuture onDone = new CompletableFuture();
        CompletableFuture[] futureArray = new CompletableFuture[futures.size()];
        CompletableFuture.allOf(futures.toArray(futureArray)).whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                onDone.completeExceptionally((Throwable)throwable);
            } else {
                boolean[] error = new boolean[]{false};
                List results = futures.stream().map(f -> {
                    try {
                        return f.join();
                    }
                    catch (Exception e) {
                        error[0] = true;
                        this.handleError(e, ((TaskHolder)this.currentHolder).task);
                        return null;
                    }
                }).collect(Collectors.toList());
                if (error[0]) {
                    onDone.completeExceptionally(new Exception("Future Dependant had an exception"));
                } else {
                    onDone.complete(results);
                }
            }
        });
        return onDone;
    }

    private class TaskHolder<R, A> {
        private final TaskChain<?> chain;
        private final TaskChainTasks.Task<R, A> task;
        final Boolean async;
        private boolean executed = false;
        private boolean aborted = false;
        private final int actionIndex;

        private TaskHolder(TaskChain<?> chain, Boolean async, TaskChainTasks.Task<R, A> task) {
            this.actionIndex = TaskChain.this.actionIndex++;
            this.task = task;
            this.chain = chain;
            this.async = async;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            Object arg = ((TaskChain)this.chain).previous;
            ((TaskChain)this.chain).previous = null;
            TaskChain.this.currentActionIndex = this.actionIndex;
            TaskChain prevChain = (TaskChain)currentChain.get();
            try {
                currentChain.set(this.chain);
                if (this.task instanceof TaskChainTasks.FutureTask) {
                    CompletableFuture future = ((TaskChainTasks.FutureTask)this.task).runFuture(arg);
                    if (future == null) {
                        throw new NullPointerException("Must return a Future");
                    }
                    future.whenComplete((r, throwable) -> {
                        if (throwable != null) {
                            ((TaskChain)this.chain).handleError(throwable, this.task);
                            this.abort();
                        } else {
                            this.next(r);
                        }
                    });
                } else if (this.task instanceof TaskChainTasks.AsyncExecutingTask) {
                    ((TaskChainTasks.AsyncExecutingTask)this.task).runAsync(arg, this::next);
                } else {
                    this.next(this.task.run(arg));
                }
            }
            catch (Throwable e) {
                if (e instanceof AbortChainException) {
                    this.abort();
                    return;
                }
                ((TaskChain)this.chain).handleError(e, this.task);
                this.abort();
            }
            finally {
                if (prevChain != null) {
                    currentChain.set(prevChain);
                } else {
                    currentChain.remove();
                }
            }
        }

        private synchronized void abort() {
            this.aborted = true;
            ((TaskChain)this.chain).abortExecutingChain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void next(Object resp) {
            TaskHolder taskHolder = this;
            synchronized (taskHolder) {
                if (this.aborted) {
                    this.chain.done(false);
                    return;
                }
                if (this.executed) {
                    this.chain.done(false);
                    throw new RuntimeException("This task has already been executed.");
                }
                this.executed = true;
            }
            ((TaskChain)this.chain).async = !TaskChain.this.impl.isMainThread();
            ((TaskChain)this.chain).previous = resp;
            ((TaskChain)this.chain).nextTask();
        }
    }
}

