/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.taskchain;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.polydev.gaea.libs.taskchain.TaskChain;
import org.polydev.gaea.libs.taskchain.TaskChainFactory;
import org.polydev.gaea.libs.taskchain.TaskChainTasks;

class SharedTaskChain<R>
extends TaskChain<R> {
    private final String name;
    private final Map<String, Queue<SharedTaskChain>> sharedChains;
    private Queue<SharedTaskChain> queue;
    private volatile boolean isPending;
    private volatile boolean canExecute = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SharedTaskChain(String name, TaskChainFactory factory) {
        super(factory);
        this.sharedChains = factory.getSharedChains();
        this.name = name;
        Map<String, Queue<SharedTaskChain>> map = this.sharedChains;
        synchronized (map) {
            this.queue = this.sharedChains.get(this.name);
            if (this.queue == null) {
                this.queue = new ConcurrentLinkedQueue<SharedTaskChain>();
                this.sharedChains.put(this.name, this.queue);
            }
            this.queue.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Consumer<Boolean> done, BiConsumer<Exception, TaskChainTasks.Task<?, ?>> errorHandler) {
        boolean shouldExecute;
        this.setErrorHandler(errorHandler);
        this.setDoneCallback(finished -> {
            this.setDoneCallback(done);
            this.done((boolean)finished);
            this.processQueue();
        });
        Map<String, Queue<SharedTaskChain>> map = this.sharedChains;
        synchronized (map) {
            this.isPending = this.queue.peek() != this;
            boolean bl = shouldExecute = !this.isPending && this.canExecute;
            if (shouldExecute) {
                this.canExecute = false;
            }
        }
        if (shouldExecute) {
            this.execute0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        SharedTaskChain next;
        this.queue.poll();
        Map<String, Queue<SharedTaskChain>> map = this.sharedChains;
        synchronized (map) {
            next = this.queue.peek();
            if (next == null) {
                this.sharedChains.remove(this.name);
                return;
            }
            if (!next.isPending) {
                return;
            }
            this.canExecute = false;
        }
        next.execute0();
    }
}

