/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.taskchain;

import java.util.concurrent.TimeUnit;
import org.polydev.gaea.libs.taskchain.AsyncQueue;
import org.polydev.gaea.libs.taskchain.TaskChain;
import org.polydev.gaea.libs.taskchain.TaskChainFactory;

public interface GameInterface {
    public boolean isMainThread();

    public AsyncQueue getAsyncQueue();

    public void postToMain(Runnable var1);

    default public void postAsync(Runnable run) {
        this.getAsyncQueue().postAsync(run);
    }

    public void scheduleTask(int var1, Runnable var2);

    public void registerShutdownHandler(TaskChainFactory var1);

    default public void scheduleTask(int duration, TimeUnit units, Runnable run) {
        this.postAsync(() -> {
            try {
                Thread.sleep(units.toMillis(duration));
                run.run();
            }
            catch (InterruptedException e) {
                TaskChain.abort();
            }
        });
    }
}

