/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.taskchain;

import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.polydev.gaea.libs.taskchain.AsyncQueue;
import org.polydev.gaea.libs.taskchain.GameInterface;
import org.polydev.gaea.libs.taskchain.TaskChain;
import org.polydev.gaea.libs.taskchain.TaskChainAbortAction;
import org.polydev.gaea.libs.taskchain.TaskChainAsyncQueue;
import org.polydev.gaea.libs.taskchain.TaskChainFactory;

public class BukkitTaskChainFactory
extends TaskChainFactory {
    public static final TaskChainAbortAction<Player, String, ?> MESSAGE = new TaskChainAbortAction<Player, String, Object>(){

        @Override
        public void onAbort(TaskChain<?> chain, Player player, String message) {
            player.sendMessage(message);
        }
    };
    public static final TaskChainAbortAction<Player, String, ?> COLOR_MESSAGE = new TaskChainAbortAction<Player, String, Object>(){

        @Override
        public void onAbort(TaskChain<?> chain, Player player, String message) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    };

    private BukkitTaskChainFactory(Plugin plugin, AsyncQueue asyncQueue) {
        super(new BukkitGameInterface(plugin, asyncQueue));
    }

    public static TaskChainFactory create(Plugin plugin) {
        return new BukkitTaskChainFactory(plugin, new TaskChainAsyncQueue());
    }

    private static class BukkitGameInterface
    implements GameInterface {
        private final Plugin plugin;
        private final AsyncQueue asyncQueue;

        BukkitGameInterface(Plugin plugin, AsyncQueue asyncQueue) {
            this.plugin = plugin;
            this.asyncQueue = asyncQueue;
        }

        @Override
        public AsyncQueue getAsyncQueue() {
            return this.asyncQueue;
        }

        @Override
        public boolean isMainThread() {
            return Bukkit.isPrimaryThread();
        }

        @Override
        public void postToMain(Runnable run) {
            if (this.plugin.isEnabled()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, run);
            } else {
                run.run();
            }
        }

        @Override
        public void scheduleTask(int ticks, Runnable run) {
            if (this.plugin.isEnabled()) {
                Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, run, (long)ticks);
            } else {
                run.run();
            }
        }

        @Override
        public void registerShutdownHandler(final TaskChainFactory factory) {
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler
                public void onPluginDisable(PluginDisableEvent event) {
                    if (event.getPlugin().equals(plugin)) {
                        factory.shutdown(60, TimeUnit.SECONDS);
                    }
                }
            }, this.plugin);
        }
    }
}

