/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.commons.rng.core.source64;

import java.util.Arrays;
import org.polydev.gaea.libs.commons.rng.JumpableUniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.UniformRandomProvider;
import org.polydev.gaea.libs.commons.rng.core.source64.LongProvider;
import org.polydev.gaea.libs.commons.rng.core.util.NumberFactory;

public class XorShift1024Star
extends LongProvider
implements JumpableUniformRandomProvider {
    private static final int SEED_SIZE = 16;
    private static final long[] JUMP_COEFFICIENTS = new long[]{-8924956236279331811L, -6645523562763818923L, 6572057659653707831L, 4938671967096216094L, 3458459993260519232L, -2581239258607468510L, 3916182429352585840L, -6142490363719071048L, -4266174017505289453L, 6839126324828817723L, 7572038374137779520L, 8723688107328792229L, 819591658532496040L, 324108011427370141L, -5075132425047734838L, 2902007988922235075L};
    private final long[] state = new long[16];
    private final long multiplier;
    private int index;

    public XorShift1024Star(long[] seed) {
        this(seed, 1181783497276652981L);
    }

    protected XorShift1024Star(long[] seed, long multiplier) {
        this.setSeedInternal(seed);
        this.multiplier = multiplier;
    }

    protected XorShift1024Star(XorShift1024Star source) {
        super(source);
        System.arraycopy(source.state, 0, this.state, 0, 16);
        this.multiplier = source.multiplier;
        this.index = source.index;
    }

    @Override
    protected byte[] getStateInternal() {
        long[] s = Arrays.copyOf(this.state, 17);
        s[16] = this.index;
        return this.composeStateInternal(NumberFactory.makeByteArray(s), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 136);
        long[] tmp = NumberFactory.makeLongArray(c[0]);
        System.arraycopy(tmp, 0, this.state, 0, 16);
        this.index = (int)tmp[16];
        super.setStateInternal(c[1]);
    }

    private void setSeedInternal(long[] seed) {
        this.fillState(this.state, seed);
        this.index = 0;
    }

    @Override
    public long next() {
        long s0 = this.state[this.index];
        this.index = this.index + 1 & 0xF;
        long s1 = this.state[this.index];
        s1 ^= s1 << 31;
        this.state[this.index] = s1 ^ s0 ^ s1 >>> 11 ^ s0 >>> 30;
        return this.state[this.index] * this.multiplier;
    }

    @Override
    public UniformRandomProvider jump() {
        XorShift1024Star copy = this.copy();
        this.performJump();
        return copy;
    }

    protected XorShift1024Star copy() {
        return new XorShift1024Star(this);
    }

    private void performJump() {
        long[] newState = new long[16];
        for (long jc : JUMP_COEFFICIENTS) {
            for (int b = 0; b < 64; ++b) {
                if ((jc & 1L << b) != 0L) {
                    for (int i = 0; i < 16; ++i) {
                        int n = i;
                        newState[n] = newState[n] ^ this.state[i + this.index & 0xF];
                    }
                }
                this.next();
            }
        }
        for (int j = 0; j < 16; ++j) {
            this.state[j + this.index & 0xF] = newState[j];
        }
        this.resetCachedState();
    }
}

