/*
 * Decompiled with CFR 0.152.
 */
package org.polydev.gaea.libs.commons.rng.core.source64;

import org.polydev.gaea.libs.commons.rng.core.source64.LongProvider;
import org.polydev.gaea.libs.commons.rng.core.util.NumberFactory;

public class PcgRxsMXs64
extends LongProvider {
    private static final int SEED_SIZE = 2;
    private long state;
    private long increment;

    public PcgRxsMXs64(long[] seed) {
        if (seed.length < 2) {
            long[] tmp = new long[2];
            this.fillState(tmp, seed);
            this.setSeedInternal(tmp);
        } else {
            this.setSeedInternal(seed);
        }
    }

    private void setSeedInternal(long[] seed) {
        this.increment = seed[1] << 1 | 1L;
        this.state = this.bump(seed[0] + this.increment);
    }

    private long bump(long input) {
        return input * 6364136223846793005L + this.increment;
    }

    @Override
    public long next() {
        long x = this.state;
        this.state = this.bump(this.state);
        long word = (x >>> (int)((x >>> 59) + 5L) ^ x) * -5840758589994634535L;
        return word >>> 43 ^ word;
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.state, this.increment >>> 1}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        long[] tempseed = NumberFactory.makeLongArray(c[0]);
        this.state = tempseed[0];
        this.increment = tempseed[1] << 1 | 1L;
        super.setStateInternal(c[1]);
    }
}

